/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirector;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiNode;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBridgeBiNode;
import org.optaplanner.constraint.streams.bavet.tri.BavetScoringTriNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetFilterUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetFromUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniNode;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;

class BavetConstraintStreamNodeOrderingTest {
    private final Function<ConstraintFactory, Constraint> constraintProvider = factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).groupBy((a, b) -> a, ConstraintCollectors.countBi()).filter((a, count) -> count > 0).join(TestdataLavishValueGroup.class).filter((a, b, valueGroup) -> false).penalize("Some constraint", (Score)SimpleScore.ONE);
    private BavetConstraintSession<TestdataLavishSolution, SimpleScore> session;

    BavetConstraintStreamNodeOrderingTest() {
    }

    @BeforeEach
    void initializeSession() {
        BavetConstraintStreamScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(this.constraintProvider);
        scoreDirector.setWorkingSolution((Object)TestdataLavishSolution.generateSolution());
        this.session = scoreDirector.getSession();
    }

    @Test
    void correctNumberOfFromNodes() {
        List lavishEntityFromNodeList = this.session.findFromNodeList(TestdataLavishEntity.class);
        Assertions.assertThat((List)lavishEntityFromNodeList).hasSize(1);
        List lavishValueGroupFromNodeList = this.session.findFromNodeList(TestdataLavishValueGroup.class);
        Assertions.assertThat((List)lavishValueGroupFromNodeList).hasSize(1);
        List lavishValueFromNodeList = this.session.findFromNodeList(TestdataLavishValue.class);
        Assertions.assertThat((List)lavishValueFromNodeList).isEmpty();
    }

    @Test
    void fromUniquePair() {
        List nodeList = this.session.getNodes();
        BavetFromUniNode fromNode = (BavetFromUniNode)nodeList.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fromNode.getNodeIndex()).as("fromNode is the first node of the constraint stream.", new Object[0])).isEqualTo(0);
        List fromNodeChildNodes = fromNode.getChildNodeList();
        ((ListAssert)Assertions.assertThat((List)fromNodeChildNodes).as("fromNode has a single child, a filterNode.", new Object[0])).hasSize(1);
        BavetFilterUniNode filterNode = (BavetFilterUniNode)fromNodeChildNodes.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)filterNode.getNodeIndex()).as("filterNode is the second node of the constraint stream.", new Object[0])).isEqualTo(1);
        List filterChildNodes = filterNode.getChildNodeList();
        ((ListAssert)Assertions.assertThat((List)filterChildNodes).as("filterNode has two children, left and right join bridge for the unique pair.", new Object[0])).hasSize(2);
        BavetJoinBridgeUniNode leftJoinBridgeNode = (BavetJoinBridgeUniNode)filterChildNodes.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)leftJoinBridgeNode.getNodeIndex()).as("Left JoinBridge is the third node of the constraint stream.", new Object[0])).isEqualTo(2);
        BavetJoinBridgeUniNode rightJoinBridgeNode = (BavetJoinBridgeUniNode)filterChildNodes.get(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)rightJoinBridgeNode.getNodeIndex()).as("Right JoinBridge is the fourth node of the constraint stream.", new Object[0])).isEqualTo(3);
    }

    @Test
    void secondJoin() {
        List nodeList = this.session.getNodes();
        BavetFromUniNode fromNode = (BavetFromUniNode)nodeList.get(9);
        ((AbstractIntegerAssert)Assertions.assertThat((int)fromNode.getNodeIndex()).as("Second fromNode follows the join (4), group (6), filter (7), left join bridge (8).", new Object[0])).isEqualTo(9);
        List fromNodeChildNodes = fromNode.getChildNodeList();
        ((ListAssert)Assertions.assertThat((List)fromNodeChildNodes).as("Second fromNode has a single child, the right JoinBridge.", new Object[0])).hasSize(1);
        BavetJoinBridgeUniNode rightJoinBridgeNode = (BavetJoinBridgeUniNode)fromNodeChildNodes.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)rightJoinBridgeNode.getNodeIndex()).as("Right JoinBridge is the eleventh node of the constraint stream.", new Object[0])).isEqualTo(10);
    }

    @Test
    void groupByAndBridge() {
        List nodeList = this.session.getNodes();
        SoftAssertions.assertSoftly(softly -> {
            ((ObjectAssert)softly.assertThat(nodeList).element(5)).isInstanceOf(BavetGroupBridgeBiNode.class);
            ((ObjectAssert)softly.assertThat(nodeList).element(6)).isInstanceOf(BavetGroupBiNode.class);
        });
    }

    @Test
    void scoring() {
        ArrayList scoringNodeCollection = new ArrayList(this.session.getScoringNodeList());
        Assertions.assertThat(scoringNodeCollection).hasSize(1);
        ((ObjectAssert)Assertions.assertThat(scoringNodeCollection).first()).isInstanceOf(BavetScoringTriNode.class);
        BavetScoringTriNode scoringNode = (BavetScoringTriNode)scoringNodeCollection.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)scoringNode.getNodeIndex()).as("Single scoring node follows final join (11) and filter (12).", new Object[0])).isEqualTo(13);
    }

    protected BavetConstraintStreamScoreDirector<TestdataLavishSolution, SimpleScore> buildScoreDirector(Function<ConstraintFactory, Constraint> function) {
        BavetConstraintStreamScoreDirectorFactory scoreDirectorFactory = new BavetConstraintStreamScoreDirectorFactory(TestdataLavishSolution.buildSolutionDescriptor(), constraintFactory -> new Constraint[]{(Constraint)function.apply(constraintFactory)});
        return scoreDirectorFactory.buildScoreDirector(false, false);
    }
}

