/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardMediumSoftLongScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardmediumsoftlong.HardMediumSoftLongScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardMediumSoftLongScoreSolution;

class HardMediumSoftLongScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardMediumSoftLongScoreSolution, HardMediumSoftLongScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    HardMediumSoftLongScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftLongScore.ONE_HARD);
        HardMediumSoftLongScoreInliner scoreInliner = new HardMediumSoftLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.ZERO);
    }

    @Test
    void impactHard() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftLongScore.ofHard((long)90L));
        HardMediumSoftLongScoreInliner scoreInliner = new HardMediumSoftLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)90L, (long)0L, (long)0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)270L, (long)0L, (long)0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)90L, (long)0L, (long)0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)0L));
    }

    @Test
    void impactMedium() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftLongScore.ofMedium((long)90L));
        HardMediumSoftLongScoreInliner scoreInliner = new HardMediumSoftLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)90L, (long)0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)270L, (long)0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)90L, (long)0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)0L));
    }

    @Test
    void impactSoft() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftLongScore.ofSoft((long)90L));
        HardMediumSoftLongScoreInliner scoreInliner = new HardMediumSoftLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)90L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)270L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)90L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)0L));
    }

    @Test
    void impactAll() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftLongScore.of((long)10L, (long)100L, (long)1000L));
        HardMediumSoftLongScoreInliner scoreInliner = new HardMediumSoftLongScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)100L, (long)1000L, (long)10000L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)300L, (long)3000L, (long)30000L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)100L, (long)1000L, (long)10000L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftLongScore.of((long)0L, (long)0L, (long)0L));
    }

    @Override
    protected SolutionDescriptor<TestdataHardMediumSoftLongScoreSolution> buildSolutionDescriptor() {
        return TestdataHardMediumSoftLongScoreSolution.buildSolutionDescriptor();
    }
}

