/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardMediumSoftScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardmediumsoft.HardMediumSoftScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardMediumSoftScoreSolution;

class HardMediumSoftScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardMediumSoftScoreSolution, HardMediumSoftScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    HardMediumSoftScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftScore.ONE_HARD);
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(this.getConstaintToWeightMap(constraint), true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.ZERO);
    }

    @Test
    void impactHard() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftScore.ofHard((int)90));
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)90, (int)0, (int)0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)270, (int)0, (int)0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)90, (int)0, (int)0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactMedium() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftScore.ofMedium((int)90));
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)90, (int)0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)270, (int)0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)90, (int)0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactSoft() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftScore.ofSoft((int)90));
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)90));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)270));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)90));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Test
    void impactAll() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardMediumSoftScore.of((int)10, (int)100, (int)1000));
        HardMediumSoftScoreInliner scoreInliner = new HardMediumSoftScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)100, (int)1000, (int)10000));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)300, (int)3000, (int)30000));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)100, (int)1000, (int)10000));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardMediumSoftScore.of((int)0, (int)0, (int)0));
    }

    @Override
    protected SolutionDescriptor<TestdataHardMediumSoftScoreSolution> buildSolutionDescriptor() {
        return TestdataHardMediumSoftScoreSolution.buildSolutionDescriptor();
    }
}

