/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.SimpleScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class SimpleScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataSolution, SimpleScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    SimpleScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(SimpleScore.ONE);
        SimpleScoreInliner scoreInliner = new SimpleScoreInliner(this.getConstaintToWeightMap(constraint), true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.ZERO);
    }

    @Test
    void impact() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(SimpleScore.of((int)10));
        SimpleScoreInliner scoreInliner = new SimpleScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)100));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)300));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)100));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)SimpleScore.of((int)0));
    }

    @Override
    protected SolutionDescriptor<TestdataSolution> buildSolutionDescriptor() {
        return TestdataSolution.buildSolutionDescriptor();
    }
}

