/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetNode;
import org.optaplanner.constraint.streams.bavet.common.BavetNodeBuildPolicy;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.uni.BavetFromUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetFromUniTuple;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.constraint.Indictment;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public final class BavetConstraintSession<Solution_, Score_ extends Score<Score_>> {
    private final AbstractScoreInliner<Score_> scoreInliner;
    private final Map<Class<?>, BavetFromUniNode<Object>> declaredClassToNodeMap;
    private final List<BavetNode> nodeIndexedNodeMap;
    private final List<BavetScoringNode> scoringNodeList;
    private final Map<Class<?>, List<BavetFromUniNode<Object>>> effectiveClassToNodeListMap;
    private final List<Queue<BavetAbstractTuple>> nodeIndexToDirtyTupleQueueMap;
    private final Map<Object, List<BavetFromUniTuple<Object>>> fromTupleListMap;

    public BavetConstraintSession(boolean constraintMatchEnabled, ScoreDefinition<Score_> scoreDefinition, Map<BavetConstraint<Solution_>, Score_> constraintToWeightMap) {
        this.scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintToWeightMap, constraintMatchEnabled);
        this.declaredClassToNodeMap = new HashMap(50);
        BavetNodeBuildPolicy buildPolicy = new BavetNodeBuildPolicy(this);
        constraintToWeightMap.forEach((constraint, constraintWeight) -> constraint.createNodes(buildPolicy, this.declaredClassToNodeMap, (Score<?>)constraintWeight));
        this.nodeIndexedNodeMap = buildPolicy.getCreatedNodes();
        this.scoringNodeList = this.nodeIndexedNodeMap.stream().filter(node -> node instanceof BavetScoringNode).map(node -> (BavetScoringNode)node).collect(Collectors.toList());
        this.effectiveClassToNodeListMap = new HashMap(this.declaredClassToNodeMap.size());
        int nodeCount = this.nodeIndexedNodeMap.size();
        this.nodeIndexToDirtyTupleQueueMap = new ArrayList<Queue<BavetAbstractTuple>>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            this.nodeIndexToDirtyTupleQueueMap.add(new ArrayDeque(1000));
        }
        this.fromTupleListMap = new IdentityHashMap<Object, List<BavetFromUniTuple<Object>>>(1000);
    }

    private static void refreshTuple(BavetAbstractTuple tuple) {
        tuple.getNode().refresh(tuple);
        switch (tuple.getState()) {
            case CREATING: 
            case UPDATING: {
                tuple.setState(BavetTupleState.OK);
                return;
            }
            case DYING: 
            case ABORTING: {
                tuple.setState(BavetTupleState.DEAD);
                return;
            }
            case DEAD: {
                throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + tuple.getNode() + ") is already in the dead state (" + tuple.getState() + ").");
            }
        }
        throw new IllegalStateException("Impossible state: Tuple (" + tuple + ") in node (" + tuple.getNode() + ") is in an unexpected state (" + tuple.getState() + ").");
    }

    public List<BavetFromUniNode<Object>> findFromNodeList(Class<?> factClass) {
        return this.effectiveClassToNodeListMap.computeIfAbsent(factClass, key -> {
            ArrayList nodeList = new ArrayList();
            this.declaredClassToNodeMap.forEach((declaredClass, declaredNode) -> {
                if (declaredClass.isAssignableFrom(factClass)) {
                    nodeList.add(declaredNode);
                }
            });
            return nodeList;
        });
    }

    public void insert(Object fact) {
        Class<?> factClass = fact.getClass();
        List<BavetFromUniNode<Object>> fromNodeList = this.findFromNodeList(factClass);
        ArrayList<BavetFromUniTuple<Object>> tupleList = new ArrayList<BavetFromUniTuple<Object>>(fromNodeList.size());
        List old = this.fromTupleListMap.put(fact, tupleList);
        if (old != null) {
            throw new IllegalStateException("The fact (" + fact + ") was already inserted, so it cannot insert again.");
        }
        for (BavetFromUniNode<Object> node : fromNodeList) {
            BavetFromUniTuple<Object> tuple = node.createTuple(fact);
            tupleList.add(tuple);
            this.transitionTuple(tuple, BavetTupleState.CREATING);
        }
    }

    public void update(Object fact) {
        List<BavetFromUniTuple<Object>> tupleList = this.fromTupleListMap.get(fact);
        if (tupleList == null) {
            throw new IllegalStateException("The fact (" + fact + ") was never inserted, so it cannot update.");
        }
        for (BavetFromUniTuple<Object> tuple : tupleList) {
            this.transitionTuple(tuple, BavetTupleState.UPDATING);
        }
    }

    public void retract(Object fact) {
        List<BavetFromUniTuple<Object>> tupleList = this.fromTupleListMap.remove(fact);
        if (tupleList == null) {
            throw new IllegalStateException("The fact (" + fact + ") was never inserted, so it cannot retract.");
        }
        for (BavetFromUniTuple<Object> tuple : tupleList) {
            this.transitionTuple(tuple, BavetTupleState.DYING);
        }
    }

    public void transitionTuple(BavetAbstractTuple tuple, BavetTupleState newState) {
        if (tuple.isDirty()) {
            if (tuple.getState() != newState) {
                if (tuple.getState() == BavetTupleState.CREATING && newState == BavetTupleState.DYING) {
                    tuple.setState(BavetTupleState.ABORTING);
                } else if (tuple.getState() == BavetTupleState.UPDATING && newState == BavetTupleState.DYING) {
                    tuple.setState(BavetTupleState.DYING);
                } else {
                    throw new IllegalStateException("The tuple (" + tuple + ") already has a dirty state (" + tuple.getState() + ") so it cannot transition to newState (" + newState + ").");
                }
            }
            return;
        }
        tuple.setState(newState);
        this.nodeIndexToDirtyTupleQueueMap.get(tuple.getNodeIndex()).add(tuple);
    }

    public Score_ calculateScore(int initScore) {
        for (Queue<BavetAbstractTuple> queue : this.nodeIndexToDirtyTupleQueueMap) {
            BavetAbstractTuple tuple = queue.poll();
            while (tuple != null) {
                BavetConstraintSession.refreshTuple(tuple);
                tuple = queue.poll();
            }
        }
        return this.scoreInliner.extractScore(initScore);
    }

    public Map<String, ConstraintMatchTotal<Score_>> getConstraintMatchTotalMap() {
        return this.scoreInliner.getConstraintMatchTotalMap();
    }

    public Map<Object, Indictment<Score_>> getIndictmentMap() {
        return this.scoreInliner.getIndictmentMap();
    }

    public AbstractScoreInliner<Score_> getScoreInliner() {
        return this.scoreInliner;
    }

    public List<BavetNode> getNodes() {
        return this.nodeIndexedNodeMap;
    }

    public List<BavetScoringNode> getScoringNodeList() {
        return this.scoringNodeList;
    }
}

