/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniTuple;
import org.optaplanner.constraint.streams.bavet.uni.BavetFromUniTuple;

public final class BavetFromUniNode<A>
extends BavetAbstractUniNode<A> {
    private final Class<A> fromClass;
    private List<BavetAbstractUniNode<A>> childNodeList = new ArrayList<BavetAbstractUniNode<A>>();

    public BavetFromUniNode(BavetConstraintSession session, int nodeIndex, Class<A> fromClass) {
        super(session, nodeIndex);
        this.fromClass = fromClass;
    }

    @Override
    public void addChildNode(BavetAbstractUniNode<A> childNode) {
        this.childNodeList.add(childNode);
    }

    @Override
    public List<BavetAbstractUniNode<A>> getChildNodeList() {
        return this.childNodeList;
    }

    public int hashCode() {
        return this.fromClass.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFromUniNode) {
            BavetFromUniNode other = (BavetFromUniNode)o;
            return this.fromClass.equals(other.fromClass);
        }
        return false;
    }

    public BavetFromUniTuple<A> createTuple(A a) {
        return new BavetFromUniTuple<A>(this, a, this.childNodeList.size());
    }

    @Override
    public BavetAbstractUniTuple<A> createTuple(BavetAbstractUniTuple<A> parentTuple) {
        throw new IllegalStateException("The fromUniNode (" + this.getClass().getSimpleName() + ") can't have a parentTuple (" + parentTuple + ");");
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetFromUniTuple tuple = (BavetFromUniTuple)uncastTuple;
        List<BavetAbstractTuple> childTupleList = tuple.getChildTupleList();
        for (BavetAbstractTuple bavetAbstractTuple : childTupleList) {
            this.session.transitionTuple(bavetAbstractTuple, BavetTupleState.DYING);
        }
        childTupleList.clear();
        if (tuple.isActive()) {
            for (BavetAbstractUniNode bavetAbstractUniNode : this.childNodeList) {
                BavetAbstractUniTuple childTuple = bavetAbstractUniNode.createTuple(tuple);
                childTupleList.add(childTuple);
                this.session.transitionTuple(childTuple, BavetTupleState.CREATING);
            }
        }
    }

    public String toString() {
        return "From(" + this.fromClass.getSimpleName() + ") with " + this.childNodeList.size() + " children";
    }
}

