/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.Variable;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.constraint.streams.drools.DroolsVariableFactory;
import org.optaplanner.constraint.streams.drools.common.BiTuple;
import org.optaplanner.constraint.streams.drools.common.DirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.IndirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.PatternVariable;
import org.optaplanner.constraint.streams.drools.common.QuadTuple;
import org.optaplanner.constraint.streams.drools.common.TriTuple;
import org.optaplanner.core.impl.score.stream.JoinerType;

abstract class AbstractLeftHandSide {
    protected final DroolsVariableFactory variableFactory;

    protected AbstractLeftHandSide(DroolsVariableFactory variableFactory) {
        this.variableFactory = Objects.requireNonNull(variableFactory);
    }

    protected static Index.ConstraintType getConstraintType(JoinerType type) {
        switch (type) {
            case EQUAL: {
                return Index.ConstraintType.EQUAL;
            }
            case LESS_THAN: {
                return Index.ConstraintType.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return Index.ConstraintType.LESS_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Index.ConstraintType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return Index.ConstraintType.GREATER_OR_EQUAL;
            }
        }
        throw new IllegalStateException("Unsupported joiner type (" + type + ").");
    }

    protected static ViewItem<?> joinViewItemsWithLogicalAnd(PatternVariable<?, ?, ?> ... patternVariables) {
        List<ViewItem<?>> viewItemList = AbstractLeftHandSide.mergeViewItems(patternVariables);
        int viewItemListSize = viewItemList.size();
        ViewItem<?> firstPattern = viewItemList.get(0);
        if (viewItemListSize == 1) {
            return firstPattern;
        }
        ViewItem[] remainingPatternArray = viewItemList.subList(1, viewItemListSize).toArray(new ViewItem[0]);
        return DSL.and(firstPattern, (ViewItemBuilder[])remainingPatternArray);
    }

    protected static List<ViewItem<?>> mergeViewItems(PatternVariable<?, ?, ?> ... patternVariables) {
        ArrayList viewItemList = new ArrayList();
        for (PatternVariable<?, ?, ?> patternVariable : patternVariables) {
            viewItemList.addAll(patternVariable.build());
        }
        return viewItemList;
    }

    protected static <A, B> IndirectPatternVariable<B, BiTuple<A, B>> decompose(Variable<BiTuple<A, B>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB) {
        Function<BiTuple, Object> bExtractor = tuple -> tuple.b;
        PatternVariable tuplePatternVar = ((DirectPatternVariable)new DirectPatternVariable<BiTuple<A, B>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, bExtractor);
        return new IndirectPatternVariable<Object, BiTuple>((DirectPatternVariable<BiTuple>)tuplePatternVar, (Variable<Object>)boundVarB, bExtractor);
    }

    protected static <A, B, C> DirectPatternVariable<C> decomposeWithAccumulate(Variable<BiTuple<A, B>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> accumulateOutput) {
        PatternVariable tuplePatternVar = ((DirectPatternVariable)new DirectPatternVariable<BiTuple<A, B>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b);
        return new DirectPatternVariable<C>(accumulateOutput, ((DirectPatternVariable)tuplePatternVar).build());
    }

    protected static <A, B, C> IndirectPatternVariable<C, TriTuple<A, B, C>> decompose(Variable<TriTuple<A, B, C>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> boundVarC) {
        Function<TriTuple, Object> cExtractor = tuple -> tuple.c;
        PatternVariable tuplePatternVar = ((DirectPatternVariable)((DirectPatternVariable)new DirectPatternVariable<TriTuple<A, B, C>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b)).bind((Variable)boundVarC, cExtractor);
        return new IndirectPatternVariable<Object, TriTuple>((DirectPatternVariable<TriTuple>)tuplePatternVar, (Variable<Object>)boundVarC, cExtractor);
    }

    protected static <A, B, C, D> IndirectPatternVariable<D, QuadTuple<A, B, C, D>> decompose(Variable<QuadTuple<A, B, C, D>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> boundVarC, Variable<D> boundVarD) {
        Function<QuadTuple, Object> dExtractor = tuple -> tuple.d;
        PatternVariable tuplePatternVar = ((DirectPatternVariable)((DirectPatternVariable)((DirectPatternVariable)new DirectPatternVariable<QuadTuple<A, B, C, D>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b)).bind((Variable)boundVarC, tuple -> tuple.c)).bind((Variable)boundVarD, dExtractor);
        return new IndirectPatternVariable<Object, QuadTuple>((DirectPatternVariable<QuadTuple>)tuplePatternVar, (Variable<Object>)boundVarD, dExtractor);
    }

    protected static <A, B, C, D> DirectPatternVariable<D> decomposeWithAccumulate(Variable<TriTuple<A, B, C>> primaryVariable, ViewItem<?> prerequisitePattern, Variable<A> boundVarA, Variable<B> boundVarB, Variable<C> boundVarC, Variable<D> accumulateOutput) {
        PatternVariable tuplePatternVar = ((DirectPatternVariable)((DirectPatternVariable)new DirectPatternVariable<TriTuple<A, B, C>>(primaryVariable, prerequisitePattern).bind((Variable)boundVarA, tuple -> tuple.a)).bind((Variable)boundVarB, tuple -> tuple.b)).bind((Variable)boundVarC, tuple -> tuple.c);
        return new DirectPatternVariable<D>(accumulateOutput, ((DirectPatternVariable)tuplePatternVar).build());
    }

    protected static ViewItem<?> buildAccumulate(ViewItem<?> innerAccumulatePattern, AccumulateFunction ... accFunctions) {
        if (accFunctions.length == 0) {
            throw new IllegalStateException("Impossible state: no accumulate functions provided.");
        }
        if (accFunctions.length == 1) {
            return DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)accFunctions[0], (AccumulateFunction[])new AccumulateFunction[0]);
        }
        return DSL.accumulate(innerAccumulatePattern, (AccumulateFunction)accFunctions[0], (AccumulateFunction[])((AccumulateFunction[])Arrays.stream(accFunctions).skip(1L).toArray(AccumulateFunction[]::new)));
    }
}

