/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.drools.model.BetaIndex;
import org.drools.model.DSL;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.accumulate.AccumulateFunction;
import org.drools.model.view.ExprViewItem;
import org.drools.model.view.ViewItem;
import org.drools.model.view.ViewItemBuilder;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.bi.FilteringBiJoiner;
import org.optaplanner.constraint.streams.drools.DroolsVariableFactory;
import org.optaplanner.constraint.streams.drools.common.AbstractLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.BiLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.BiTuple;
import org.optaplanner.constraint.streams.drools.common.DirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.IndirectPatternVariable;
import org.optaplanner.constraint.streams.drools.common.PatternVariable;
import org.optaplanner.constraint.streams.drools.common.QuadLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.QuadTuple;
import org.optaplanner.constraint.streams.drools.common.RuleBuilder;
import org.optaplanner.constraint.streams.drools.common.TriLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.TriTuple;
import org.optaplanner.constraint.streams.drools.common.UniAccumulator;
import org.optaplanner.constraint.streams.drools.common.UniRuleContext;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class UniLeftHandSide<A>
extends AbstractLeftHandSide {
    private final PatternVariable<A, ?, ?> patternVariable;
    private final UniRuleContext<A> ruleContext;

    public UniLeftHandSide(Class<A> aClass, DroolsVariableFactory variableFactory) {
        this(new DirectPatternVariable(variableFactory.createVariable(aClass, "var")), variableFactory);
    }

    protected UniLeftHandSide(Variable<A> variable, List<ViewItem<?>> viewItems, DroolsVariableFactory variableFactory) {
        this(new DirectPatternVariable<A>(variable, viewItems), variableFactory);
    }

    protected UniLeftHandSide(PatternVariable<A, ?, ?> patternVariable, DroolsVariableFactory variableFactory) {
        super(variableFactory);
        this.patternVariable = Objects.requireNonNull(patternVariable);
        this.ruleContext = this.buildRuleContext();
    }

    private UniRuleContext<A> buildRuleContext() {
        return new UniRuleContext<A>(this.patternVariable.getPrimaryVariable(), this.patternVariable.build().toArray(new ViewItem[0]));
    }

    public PatternVariable<A, ?, ?> getPatternVariableA() {
        return this.patternVariable;
    }

    public UniLeftHandSide<A> andFilter(Predicate<A> predicate) {
        return new UniLeftHandSide<A>(this.patternVariable.filter(predicate), this.variableFactory);
    }

    private <B> UniLeftHandSide<A> applyJoiners(Class<B> otherFactType, Predicate<B> nullityFilter, DefaultBiJoiner<A, B> joiner, BiPredicate<A, B> predicate, boolean shouldExist) {
        Variable toExist = this.variableFactory.createVariable(otherFactType, "toExist");
        PatternDSL.PatternDef existencePattern = PatternDSL.pattern(toExist);
        if (nullityFilter != null) {
            existencePattern = existencePattern.expr("Exclude nulls using " + nullityFilter, nullityFilter::test);
        }
        if (joiner == null) {
            return this.applyFilters(existencePattern, predicate, shouldExist);
        }
        int joinerCount = joiner.getJoinerCount();
        for (int mappingIndex = 0; mappingIndex < joinerCount; ++mappingIndex) {
            JoinerType joinerType = joiner.getJoinerType(mappingIndex);
            Function leftMapping = joiner.getLeftMapping(mappingIndex);
            Function rightMapping = joiner.getRightMapping(mappingIndex);
            Predicate2 & Serializable joinPredicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightMapping.apply(b));
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)UniLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, rightMapping::apply, leftMapping::apply);
            existencePattern = existencePattern.expr("Join using joiner #" + mappingIndex + " in " + joiner, this.patternVariable.getPrimaryVariable(), (Predicate2)joinPredicate, index);
        }
        return this.applyFilters(existencePattern, predicate, shouldExist);
    }

    private <B> UniLeftHandSide<A> applyFilters(PatternDSL.PatternDef<B> existencePattern, BiPredicate<A, B> predicate, boolean shouldExist) {
        PatternDSL.PatternDef possiblyFilteredExistencePattern = predicate == null ? existencePattern : existencePattern.expr("Filter using " + predicate, this.patternVariable.getPrimaryVariable(), (Predicate2 & Serializable)(b, a) -> predicate.test(a, b));
        ExprViewItem existenceExpression = DSL.exists(possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        if (!shouldExist) {
            existenceExpression = DSL.not((ViewItemBuilder)possiblyFilteredExistencePattern, (ViewItemBuilder[])new ViewItemBuilder[0]);
        }
        return new UniLeftHandSide<A>(this.patternVariable.addDependentExpression((ViewItem<?>)existenceExpression), this.variableFactory);
    }

    private <B> UniLeftHandSide<A> existsOrNot(Class<B> bClass, BiJoiner<A, B>[] joiners, Predicate<B> nullityFilter, boolean shouldExist) {
        int indexOfFirstFilter = -1;
        Object finalJoiner = null;
        BiPredicate finalFilter = null;
        for (int i = 0; i < joiners.length; ++i) {
            Object castJoiner;
            boolean hasAFilter;
            BiJoiner<A, B> joiner = joiners[i];
            boolean bl = hasAFilter = indexOfFirstFilter >= 0;
            if (joiner instanceof FilteringBiJoiner) {
                if (!hasAFilter) {
                    indexOfFirstFilter = i;
                }
                castJoiner = (FilteringBiJoiner)joiner;
                finalFilter = finalFilter == null ? ((FilteringBiJoiner)castJoiner).getFilter() : finalFilter.and(((FilteringBiJoiner)castJoiner).getFilter());
                continue;
            }
            if (hasAFilter) {
                throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").");
            }
            castJoiner = (DefaultBiJoiner)joiner;
            finalJoiner = finalJoiner == null ? castJoiner : ((DefaultBiJoiner)finalJoiner).and((BiJoiner)castJoiner);
        }
        return this.applyJoiners(bClass, nullityFilter, (DefaultBiJoiner<A, B>)finalJoiner, finalFilter, shouldExist);
    }

    public <B> UniLeftHandSide<A> andExists(Class<B> bClass, BiJoiner<A, B>[] joiners, Predicate<B> nullityFilter) {
        return this.existsOrNot(bClass, joiners, nullityFilter, true);
    }

    public <B> UniLeftHandSide<A> andNotExists(Class<B> bClass, BiJoiner<A, B>[] joiners, Predicate<B> nullityFilter) {
        return this.existsOrNot(bClass, joiners, nullityFilter, false);
    }

    public <B> BiLeftHandSide<A, B> andJoin(UniLeftHandSide<B> right, BiJoiner<A, B> joiner) {
        DefaultBiJoiner castJoiner = (DefaultBiJoiner)joiner;
        int joinerCount = castJoiner.getJoinerCount();
        PatternVariable<A, ?, ?> newRight = right.patternVariable;
        for (int mappingIndex = 0; mappingIndex < joinerCount; ++mappingIndex) {
            JoinerType joinerType = castJoiner.getJoinerType(mappingIndex);
            newRight = newRight.filterForJoin(this.patternVariable.getPrimaryVariable(), castJoiner, joinerType, mappingIndex);
        }
        return new BiLeftHandSide<A, A>(this.patternVariable, newRight, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(UniConstraintCollector<A, ?, NewA> collector) {
        Variable accumulateOutput = this.variableFactory.createVariable("collected");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collector, accumulateOutput));
        return new UniLeftHandSide(accumulateOutput, Collections.singletonList(outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB));
        return new BiLeftHandSide(accumulateOutputA, new DirectPatternVariable(accumulateOutputB, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(accumulateOutputA, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, outerAccumulatePattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(UniConstraintCollector<A, ?, NewA> collectorA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable accumulateOutputA = this.variableFactory.createVariable("collectedA");
        Variable accumulateOutputB = this.variableFactory.createVariable("collectedB");
        Variable accumulateOutputC = this.variableFactory.createVariable("collectedC");
        Variable accumulateOutputD = this.variableFactory.createVariable("collectedD");
        ViewItem<?> outerAccumulatePattern = this.buildAccumulate(this.createAccumulateFunction(collectorA, accumulateOutputA), this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(accumulateOutputA, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, outerAccumulatePattern), this.variableFactory);
    }

    private <Out> AccumulateFunction createAccumulateFunction(UniConstraintCollector<A, ?, Out> collector, Variable<Out> out) {
        Variable variable = this.patternVariable.getPrimaryVariable();
        return new AccumulateFunction(null, () -> new UniAccumulator(variable, collector)).with(new Variable[]{variable}).as(out);
    }

    public <NewA> UniLeftHandSide<NewA> andGroupBy(Function<A, NewA> keyMapping) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMapping::apply, new AccumulateFunction[0]);
        return new UniLeftHandSide(groupKey, Collections.singletonList(groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutput));
        return new BiLeftHandSide(groupKey, new DirectPatternVariable(accumulateOutput, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC));
        return new TriLeftHandSide(groupKey, accumulateOutputB, new DirectPatternVariable(accumulateOutputC, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, UniConstraintCollector<A, ?, NewB> collectorB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable("groupKey");
        Variable accumulateOutputB = this.variableFactory.createVariable("outputB");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, keyMappingA::apply, this.createAccumulateFunction(collectorB, accumulateOutputB), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        return new QuadLeftHandSide(groupKey, accumulateOutputB, accumulateOutputC, new DirectPatternVariable(accumulateOutputD, groupByPattern), this.variableFactory);
    }

    public <NewA, NewB> BiLeftHandSide<NewA, NewB> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        IndirectPatternVariable bPatternVar = UniLeftHandSide.decompose(groupKey, groupByPattern, newA, newB);
        return new BiLeftHandSide(newA, bPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutput = this.variableFactory.createVariable("output");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), this.createAccumulateFunction(collectorC, accumulateOutput));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable cPatternVar = UniLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, accumulateOutput);
        return new TriLeftHandSide(newA, newB, cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, UniConstraintCollector<A, ?, NewC> collectorC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(BiTuple.class, "groupKey");
        Variable accumulateOutputC = this.variableFactory.createVariable("outputC");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new BiTuple(keyMappingA.apply(a), keyMappingB.apply(a)), this.createAccumulateFunction(collectorC, accumulateOutputC), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        DirectPatternVariable dPatternVar = UniLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, accumulateOutputD);
        return new QuadLeftHandSide(newA, newB, accumulateOutputC, dPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC> TriLeftHandSide<NewA, NewB, NewC> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, Function<A, NewC> keyMappingC) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new TriTuple(keyMappingA.apply(a), keyMappingB.apply(a), keyMappingC.apply(a)), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        IndirectPatternVariable cPatternVar = UniLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC);
        return new TriLeftHandSide(newA, newB, cPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, Function<A, NewC> keyMappingC, UniConstraintCollector<A, ?, NewD> collectorD) {
        Variable groupKey = this.variableFactory.createVariable(TriTuple.class, "groupKey");
        Variable accumulateOutputD = this.variableFactory.createVariable("outputD");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new TriTuple(keyMappingA.apply(a), keyMappingB.apply(a), keyMappingC.apply(a)), this.createAccumulateFunction(collectorD, accumulateOutputD));
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        DirectPatternVariable dPatternVar = UniLeftHandSide.decomposeWithAccumulate(groupKey, groupByPattern, newA, newB, newC, accumulateOutputD);
        return new QuadLeftHandSide(newA, newB, newC, dPatternVar, this.variableFactory);
    }

    public <NewA, NewB, NewC, NewD> QuadLeftHandSide<NewA, NewB, NewC, NewD> andGroupBy(Function<A, NewA> keyMappingA, Function<A, NewB> keyMappingB, Function<A, NewC> keyMappingC, Function<A, NewD> keyMappingD) {
        Variable groupKey = this.variableFactory.createVariable(QuadTuple.class, "groupKey");
        ViewItem<?> groupByPattern = this.buildGroupBy(groupKey, (Function1 & Serializable)a -> new QuadTuple(keyMappingA.apply(a), keyMappingB.apply(a), keyMappingC.apply(a), keyMappingD.apply(a)), new AccumulateFunction[0]);
        Variable newA = this.variableFactory.createVariable("newA");
        Variable newB = this.variableFactory.createVariable("newB");
        Variable newC = this.variableFactory.createVariable("newC");
        Variable newD = this.variableFactory.createVariable("newD");
        IndirectPatternVariable dPatternVar = UniLeftHandSide.decompose(groupKey, groupByPattern, newA, newB, newC, newD);
        return new QuadLeftHandSide(newA, newB, newC, dPatternVar, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andMap(Function<A, NewA> mapping) {
        IndirectPatternVariable newPatternVariableA;
        Variable newA = this.variableFactory.createVariable("mapped");
        Object mappedVariable = this.patternVariable.bind(newA, mapping);
        if (mappedVariable instanceof DirectPatternVariable) {
            newPatternVariableA = new IndirectPatternVariable((DirectPatternVariable)mappedVariable, newA, mapping);
        } else if (mappedVariable instanceof IndirectPatternVariable) {
            newPatternVariableA = new IndirectPatternVariable((IndirectPatternVariable)mappedVariable, newA, mapping);
        } else {
            throw new IllegalStateException("Impossible state: Pattern variable is neither direct nor indirect: " + this.patternVariable);
        }
        return new UniLeftHandSide<A>(newPatternVariableA, this.variableFactory);
    }

    public <NewA> UniLeftHandSide<NewA> andFlattenLast(Function<A, Iterable<NewA>> mapping) {
        Variable<A> source = this.patternVariable.getPrimaryVariable();
        Variable<NewA> newA = this.variableFactory.createFlattenedVariable("flattened", source, mapping);
        DirectPatternVariable<NewA> newPatternVariableA = new DirectPatternVariable<NewA>(newA, this.patternVariable.build());
        return new UniLeftHandSide<A>(newPatternVariableA, this.variableFactory);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate() {
        return this.ruleContext.newRuleBuilder();
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToIntFunction<A> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(ToLongFunction<A> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    public <Solution_> RuleBuilder<Solution_> andTerminate(Function<A, BigDecimal> matchWeighter) {
        return this.ruleContext.newRuleBuilder(matchWeighter);
    }

    private ViewItem<?> buildAccumulate(AccumulateFunction ... accFunctions) {
        ViewItem<?> innerAccumulatePattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        return UniLeftHandSide.buildAccumulate(innerAccumulatePattern, accFunctions);
    }

    private <GroupKey_> ViewItem<?> buildGroupBy(Variable<GroupKey_> groupKey, Function1<A, GroupKey_> groupKeyExtractor, AccumulateFunction ... accFunctions) {
        Variable<A> input = this.patternVariable.getPrimaryVariable();
        ViewItem<?> innerGroupByPattern = UniLeftHandSide.joinViewItemsWithLogicalAnd(this.patternVariable);
        return DSL.groupBy(innerGroupByPattern, input, groupKey, groupKeyExtractor, (AccumulateFunction[])accFunctions);
    }
}

