/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.bavet.BavetConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamScoreDirectorFactoryService;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.impl.score.director.InnerScoreDirectorFactory;
import org.optaplanner.core.impl.score.director.ScoreDirectorFactoryFactory;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class ScoreDirectorFactoryFactoryTest {
    ScoreDirectorFactoryFactoryTest() {
    }

    @Test
    void constraintStreamsDroolsWithAlphaNetworkCompilationEnabled() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withDroolsAlphaNetworkCompilationEnabled(true);
        InnerScoreDirectorFactory uncastScoreDirectorFactory = (InnerScoreDirectorFactory)new DroolsConstraintStreamScoreDirectorFactoryService().buildScoreDirectorFactory(null, TestdataSolution.buildSolutionDescriptor(), config).get();
        Assertions.assertThat((Object)uncastScoreDirectorFactory).isInstanceOf(DroolsConstraintStreamScoreDirectorFactory.class);
        DroolsConstraintStreamScoreDirectorFactory scoreDirectorFactory = (DroolsConstraintStreamScoreDirectorFactory)uncastScoreDirectorFactory;
        Assertions.assertThat((boolean)scoreDirectorFactory.isDroolsAlphaNetworkCompilationEnabled()).isTrue();
    }

    @Test
    void constraintStreamsDroolsWithAlphaNetworkCompilationEnabledNoDrools_throws() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withConstraintStreamImplType(ConstraintStreamImplType.BAVET).withDroolsAlphaNetworkCompilationEnabled(true);
        ScoreDirectorFactoryFactory factoryFactory = new ScoreDirectorFactoryFactory(config);
        Assertions.assertThatCode(() -> factoryFactory.buildScoreDirectorFactory(ScoreDirectorFactoryFactoryTest.class.getClassLoader(), EnvironmentMode.FAST_ASSERT, TestdataSolution.buildSolutionDescriptor())).hasMessage("If there is no scoreDrl (null), scoreDrlFile (null) or constraintProviderClass (class org.optaplanner.constraint.streams.ScoreDirectorFactoryFactoryTest$TestdataConstraintProvider) with DROOLS impl type (BAVET), there can be no droolsAlphaNetworkCompilationEnabled (true) either.");
    }

    @Test
    void constraintStreamsKieBaseSupplierNoDrools_throws() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withConstraintStreamImplType(ConstraintStreamImplType.BAVET).withGizmoKieBaseSupplier(() -> null);
        ScoreDirectorFactoryFactory factoryFactory = new ScoreDirectorFactoryFactory(config);
        Assertions.assertThatCode(() -> factoryFactory.buildScoreDirectorFactory(ScoreDirectorFactoryFactoryTest.class.getClassLoader(), EnvironmentMode.FAST_ASSERT, TestdataSolution.buildSolutionDescriptor())).hasMessageContaining("If there is no constraintProviderClass (class org.optaplanner.constraint.streams.ScoreDirectorFactoryFactoryTest$TestdataConstraintProvider) with DROOLS impl type (BAVET), there can be no gizmoKieBaseSupplier ");
    }

    @Test
    void constraintStreamsDroolsWithAlphaNetworkCompilationDisabled() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withDroolsAlphaNetworkCompilationEnabled(false);
        InnerScoreDirectorFactory uncastScoreDirectorFactory = (InnerScoreDirectorFactory)new DroolsConstraintStreamScoreDirectorFactoryService().buildScoreDirectorFactory(null, TestdataSolution.buildSolutionDescriptor(), config).get();
        Assertions.assertThat((Object)uncastScoreDirectorFactory).isInstanceOf(DroolsConstraintStreamScoreDirectorFactory.class);
        DroolsConstraintStreamScoreDirectorFactory scoreDirectorFactory = (DroolsConstraintStreamScoreDirectorFactory)uncastScoreDirectorFactory;
        Assertions.assertThat((boolean)scoreDirectorFactory.isDroolsAlphaNetworkCompilationEnabled()).isFalse();
    }

    @Test
    void constraintStreamsBavet() {
        ScoreDirectorFactoryConfig config = new ScoreDirectorFactoryConfig().withConstraintProviderClass(TestdataConstraintProvider.class).withConstraintStreamImplType(ConstraintStreamImplType.BAVET);
        AbstractConstraintStreamScoreDirectorFactory scoreDirectorFactory = (AbstractConstraintStreamScoreDirectorFactory)new BavetConstraintStreamScoreDirectorFactoryService().buildScoreDirectorFactory(null, TestdataSolution.buildSolutionDescriptor(), config).get();
        Assertions.assertThat((Object)scoreDirectorFactory).isInstanceOf(BavetConstraintStreamScoreDirectorFactory.class);
    }

    public static class TestdataConstraintProvider
    implements ConstraintProvider {
        public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
            return new Constraint[0];
        }
    }
}

