/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.BendableScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataBendableScoreSolution;

class BendableScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataBendableScoreSolution, BendableScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    BendableScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(this.buildScore(1, 1, 1));
        BendableScoreInliner scoreInliner = new BendableScoreInliner(this.getConstaintToWeightMap(constraint), true, 1, 2);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 0));
    }

    @Test
    void impactHard() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(this.buildScore(90, 0, 0));
        BendableScoreInliner scoreInliner = new BendableScoreInliner(this.getConstaintToWeightMap(constraint), true, 1, 2);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90, 0, 0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(270, 0, 0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(90, 0, 0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 0));
    }

    @Test
    void impactSoft1() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(this.buildScore(0, 90, 0));
        BendableScoreInliner scoreInliner = new BendableScoreInliner(this.getConstaintToWeightMap(constraint), true, 1, 2);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 90, 0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 270, 0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 90, 0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 0));
    }

    @Test
    void impactSoft2() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(this.buildScore(0, 0, 90));
        BendableScoreInliner scoreInliner = new BendableScoreInliner(this.getConstaintToWeightMap(constraint), true, 1, 2);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 90));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 270));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 90));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 0));
    }

    @Test
    void impactAll() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(this.buildScore(10, 100, 1000));
        BendableScoreInliner scoreInliner = new BendableScoreInliner(this.getConstaintToWeightMap(constraint), true, 1, 2);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100, 1000, 10000));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(300, 3000, 30000));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(100, 1000, 10000));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)this.buildScore(0, 0, 0));
    }

    @Override
    protected SolutionDescriptor<TestdataBendableScoreSolution> buildSolutionDescriptor() {
        return TestdataBendableScoreSolution.buildSolutionDescriptor();
    }

    private BendableScore buildScore(int hard, int soft1, int soft2) {
        return BendableScore.of((int[])new int[]{hard}, (int[])new int[]{soft1, soft2});
    }
}

