/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.math.BigDecimal;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardSoftBigDecimalScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoftbigdecimal.HardSoftBigDecimalScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardSoftBigDecimalScoreSolution;

class HardSoftBigDecimalScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardSoftBigDecimalScoreSolution, HardSoftBigDecimalScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    HardSoftBigDecimalScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardSoftBigDecimalScore.ONE_HARD);
        HardSoftBigDecimalScoreInliner scoreInliner = new HardSoftBigDecimalScoreInliner(this.getConstaintToWeightMap(constraint), true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.ZERO);
    }

    @Test
    void impactHard() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardSoftBigDecimalScore.ofHard((BigDecimal)BigDecimal.valueOf(90L)));
        HardSoftBigDecimalScoreInliner scoreInliner = new HardSoftBigDecimalScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.ONE, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(90L), (BigDecimal)BigDecimal.ZERO));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(2L), EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(270L), (BigDecimal)BigDecimal.ZERO));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(90L), (BigDecimal)BigDecimal.ZERO));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(0L), (BigDecimal)BigDecimal.ZERO));
    }

    @Test
    void impactSoft() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardSoftBigDecimalScore.ofSoft((BigDecimal)BigDecimal.valueOf(90L)));
        HardSoftBigDecimalScoreInliner scoreInliner = new HardSoftBigDecimalScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.ONE, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.valueOf(90L)));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(2L), EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.valueOf(270L)));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.valueOf(90L)));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO));
    }

    @Test
    void impactAll() {
        AbstractScoreInlinerTest.TestConstraint constraint = this.buildConstraint(HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(10L), (BigDecimal)BigDecimal.valueOf(100L)));
        HardSoftBigDecimalScoreInliner scoreInliner = new HardSoftBigDecimalScoreInliner(this.getConstaintToWeightMap(constraint), true);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(constraint);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(BigDecimal.TEN, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(1000L)));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(BigDecimal.valueOf(20L), EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(300L), (BigDecimal)BigDecimal.valueOf(3000L)));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.valueOf(100L), (BigDecimal)BigDecimal.valueOf(1000L)));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftBigDecimalScore.of((BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO));
    }

    @Override
    protected SolutionDescriptor<TestdataHardSoftBigDecimalScoreSolution> buildSolutionDescriptor() {
        return TestdataHardSoftBigDecimalScoreSolution.buildSolutionDescriptor();
    }
}

