/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;

public final class JoinerUtils {
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    private JoinerUtils() {
    }

    public static <A, B> Function<A, Object[]> combineLeftMappings(DefaultBiJoiner<A, B> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return a -> EMPTY_OBJECT_ARRAY;
        }
        if (joinerCount == 1) {
            Function mapping = joiner.getLeftMapping(0);
            return a -> new Object[]{mapping.apply(a)};
        }
        return a -> {
            Object[] result = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                result[i] = joiner.getLeftMapping(i).apply(a);
            }
            return result;
        };
    }

    public static <A, B, C> BiFunction<A, B, Object[]> combineLeftMappings(DefaultTriJoiner<A, B, C> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return (a, b) -> EMPTY_OBJECT_ARRAY;
        }
        if (joinerCount == 1) {
            BiFunction mapping = joiner.getLeftMapping(0);
            return (a, b) -> new Object[]{mapping.apply(a, b)};
        }
        return (a, b) -> {
            Object[] result = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                result[i] = joiner.getLeftMapping(i).apply(a, b);
            }
            return result;
        };
    }

    public static <Right_> Function<Right_, Object[]> combineRightMappings(AbstractJoiner<Right_> joiner) {
        int joinerCount = joiner.getJoinerCount();
        if (joinerCount == 0) {
            return x -> EMPTY_OBJECT_ARRAY;
        }
        if (joinerCount == 1) {
            Function mapping = joiner.getRightMapping(0);
            return x -> new Object[]{mapping.apply(x)};
        }
        return x -> {
            Object[] result = new Object[joinerCount];
            for (int i = 0; i < joinerCount; ++i) {
                result[i] = joiner.getRightMapping(i).apply(x);
            }
            return result;
        };
    }
}

