/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractTuple;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringNode;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriNode;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriTuple;
import org.optaplanner.constraint.streams.bavet.tri.BavetScoringTriTuple;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;

public final class BavetScoringTriNode<A, B, C>
extends BavetAbstractTriNode<A, B, C>
implements BavetScoringNode {
    private final Score<?> constraintWeight;
    private final TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter;

    public BavetScoringTriNode(BavetConstraintSession session, int nodeIndex, Score<?> constraintWeight, TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter) {
        super(session, nodeIndex);
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
    }

    @Override
    public BavetScoringTriTuple<A, B, C> createTuple(BavetAbstractTriTuple<A, B, C> parentTuple) {
        return new BavetScoringTriTuple<A, B, C>(this, parentTuple);
    }

    @Override
    public void refresh(BavetAbstractTuple uncastTuple) {
        BavetScoringTriTuple tuple = (BavetScoringTriTuple)uncastTuple;
        Object a = tuple.getFactA();
        Object b = tuple.getFactB();
        Object c = tuple.getFactC();
        UndoScoreImpacter oldUndoScoreImpacter = tuple.getUndoScoreImpacter();
        if (oldUndoScoreImpacter != null) {
            oldUndoScoreImpacter.run();
        }
        if (tuple.isActive()) {
            UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)this.scoreImpacter.apply(a, b, c);
            tuple.setUndoScoreImpacter(undoScoreImpacter);
        } else {
            tuple.setUndoScoreImpacter(null);
        }
    }

    public String toString() {
        return "Scoring(" + this.constraintWeight + ")";
    }
}

