/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools.common;

import java.io.Serializable;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.model.BetaIndex;
import org.drools.model.BetaIndex2;
import org.drools.model.BetaIndex3;
import org.drools.model.Index;
import org.drools.model.PatternDSL;
import org.drools.model.Variable;
import org.drools.model.functions.Function1;
import org.drools.model.functions.Function2;
import org.drools.model.functions.Function3;
import org.drools.model.functions.Function4;
import org.drools.model.functions.Predicate1;
import org.drools.model.functions.Predicate2;
import org.drools.model.functions.Predicate3;
import org.drools.model.functions.Predicate4;
import org.drools.model.view.ViewItem;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.drools.common.AbstractLeftHandSide;
import org.optaplanner.constraint.streams.drools.common.PatternVariable;
import org.optaplanner.constraint.streams.quad.DefaultQuadJoiner;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.impl.score.stream.JoinerType;

abstract class AbstractPatternVariable<A, PatternVar_, Child_ extends AbstractPatternVariable<A, PatternVar_, Child_>>
implements PatternVariable<A, PatternVar_, Child_> {
    private final Variable<A> primaryVariable;
    private final Supplier<PatternDSL.PatternDef<PatternVar_>> patternSupplier;
    private final List<ViewItem<?>> prerequisiteExpressions;
    private final List<ViewItem<?>> dependentExpressions;

    protected AbstractPatternVariable(Variable<A> aVariable, Supplier<PatternDSL.PatternDef<PatternVar_>> patternSupplier, List<ViewItem<?>> prerequisiteExpressions, List<ViewItem<?>> dependentExpressions) {
        this.primaryVariable = aVariable;
        this.patternSupplier = patternSupplier;
        this.prerequisiteExpressions = prerequisiteExpressions;
        this.dependentExpressions = dependentExpressions;
    }

    protected AbstractPatternVariable(AbstractPatternVariable<?, PatternVar_, ?> patternCreator, Variable<A> boundVariable) {
        this.primaryVariable = boundVariable;
        this.patternSupplier = patternCreator.getPatternSupplier();
        this.prerequisiteExpressions = patternCreator.getPrerequisiteExpressions();
        this.dependentExpressions = patternCreator.getDependentExpressions();
    }

    protected AbstractPatternVariable(AbstractPatternVariable<A, PatternVar_, ?> patternCreator, UnaryOperator<PatternDSL.PatternDef<PatternVar_>> patternMutator) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = () -> (PatternDSL.PatternDef)patternMutator.apply(patternCreator.patternSupplier.get());
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = patternCreator.dependentExpressions;
    }

    protected AbstractPatternVariable(AbstractPatternVariable<A, PatternVar_, ?> patternCreator, ViewItem<?> dependentExpression) {
        this.primaryVariable = patternCreator.primaryVariable;
        this.patternSupplier = patternCreator.patternSupplier;
        this.prerequisiteExpressions = patternCreator.prerequisiteExpressions;
        this.dependentExpressions = Stream.concat(patternCreator.dependentExpressions.stream(), Stream.of(dependentExpression)).collect(Collectors.toList());
    }

    @Override
    public Variable<A> getPrimaryVariable() {
        return this.primaryVariable;
    }

    public Supplier<PatternDSL.PatternDef<PatternVar_>> getPatternSupplier() {
        return this.patternSupplier;
    }

    @Override
    public List<ViewItem<?>> getPrerequisiteExpressions() {
        return this.prerequisiteExpressions;
    }

    @Override
    public List<ViewItem<?>> getDependentExpressions() {
        return this.dependentExpressions;
    }

    protected abstract A extract(PatternVar_ var1);

    protected abstract Child_ create(UnaryOperator<PatternDSL.PatternDef<PatternVar_>> var1);

    protected abstract Child_ create(ViewItem<?> var1);

    @Override
    public final Child_ filter(Predicate<A> predicate) {
        return this.create(p -> p.expr("Filter using " + predicate, (Predicate1 & Serializable)a -> predicate.test(this.extract(a))));
    }

    @Override
    public final <LeftJoinVar_> Child_ filter(BiPredicate<LeftJoinVar_, A> predicate, Variable<LeftJoinVar_> leftJoinVariable) {
        return this.create(p -> p.expr("Filter using " + predicate, leftJoinVariable, (Predicate2 & Serializable)(a, leftJoinVar) -> predicate.test(leftJoinVar, this.extract(a))));
    }

    @Override
    public final <LeftJoinVarA_, LeftJoinVarB_> Child_ filter(TriPredicate<LeftJoinVarA_, LeftJoinVarB_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB) {
        return this.create(p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, (Predicate3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> predicate.test(leftJoinVarA, leftJoinVarB, this.extract(a))));
    }

    @Override
    public final <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ filter(QuadPredicate<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> predicate, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC) {
        return this.create(p -> p.expr("Filter using " + predicate, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Predicate4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> predicate.test(leftJoinVarA, leftJoinVarB, leftJoinVarC, this.extract(a))));
    }

    public final <LeftJoinVar_> Child_ filterForJoin(Variable<LeftJoinVar_> leftJoinVar, DefaultBiJoiner<LeftJoinVar_, A> joiner, JoinerType joinerType, int mappingIndex) {
        Function leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate2 & Serializable predicate = (Predicate2 & Serializable)(b, a) -> joinerType.matches(leftMapping.apply(a), rightExtractor.apply(b));
        return this.create(p -> {
            BetaIndex index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, leftMapping::apply);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVar, predicate, index);
        });
    }

    public final <LeftJoinVarA_, LeftJoinVarB_> Child_ filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, DefaultTriJoiner<LeftJoinVarA_, LeftJoinVarB_, A> joiner, JoinerType joinerType, int mappingIndex) {
        BiFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate3 & Serializable predicate = (Predicate3 & Serializable)(c, a, b) -> joinerType.matches(leftMapping.apply(a, b), rightExtractor.apply(c));
        return this.create(p -> {
            BetaIndex2 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, leftMapping::apply, Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, predicate, index);
        });
    }

    public final <LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ filterForJoin(Variable<LeftJoinVarA_> leftJoinVarA, Variable<LeftJoinVarB_> leftJoinVarB, Variable<LeftJoinVarC_> leftJoinVarC, DefaultQuadJoiner<LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, A> joiner, JoinerType joinerType, int mappingIndex) {
        TriFunction leftMapping = joiner.getLeftMapping(mappingIndex);
        Function rightMapping = joiner.getRightMapping(mappingIndex);
        Function1 & Serializable rightExtractor = (Function1 & Serializable)b -> rightMapping.apply(this.extract(b));
        Predicate4 & Serializable predicate = (Predicate4 & Serializable)(d, a, b, c) -> joinerType.matches(leftMapping.apply(a, b, c), rightExtractor.apply(d));
        return this.create(p -> {
            BetaIndex3 index = PatternDSL.betaIndexedBy(Object.class, (Index.ConstraintType)AbstractLeftHandSide.getConstraintType(joinerType), (int)mappingIndex, (Function1)rightExtractor, (arg_0, arg_1, arg_2) -> ((TriFunction)leftMapping).apply(arg_0, arg_1, arg_2), Object.class);
            return p.expr("Join using joiner #" + mappingIndex + " in " + joiner, leftJoinVarA, leftJoinVarB, leftJoinVarC, predicate, index);
        });
    }

    @Override
    public final <BoundVar_> Child_ bind(Variable<BoundVar_> boundVariable, Function<A, BoundVar_> bindingFunction) {
        return this.create(p -> p.bind(boundVariable, (Function1 & Serializable)a -> bindingFunction.apply(this.extract(a))));
    }

    @Override
    public final <BoundVar_, LeftJoinVar_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVar_> leftJoinVariable, BiFunction<A, LeftJoinVar_, BoundVar_> bindingFunction) {
        return this.create(p -> p.bind(boundVariable, leftJoinVariable, (Function2 & Serializable)(a, leftJoinVar) -> bindingFunction.apply(this.extract(a), leftJoinVar)));
    }

    @Override
    public final <BoundVar_, LeftJoinVarA_, LeftJoinVarB_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, TriFunction<A, LeftJoinVarA_, LeftJoinVarB_, BoundVar_> bindingFunction) {
        return this.create(p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, (Function3 & Serializable)(a, leftJoinVarA, leftJoinVarB) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB)));
    }

    @Override
    public final <BoundVar_, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_> Child_ bind(Variable<BoundVar_> boundVariable, Variable<LeftJoinVarA_> leftJoinVariableA, Variable<LeftJoinVarB_> leftJoinVariableB, Variable<LeftJoinVarC_> leftJoinVariableC, QuadFunction<A, LeftJoinVarA_, LeftJoinVarB_, LeftJoinVarC_, BoundVar_> bindingFunction) {
        return this.create(p -> p.bind(boundVariable, leftJoinVariableA, leftJoinVariableB, leftJoinVariableC, (Function4 & Serializable)(a, leftJoinVarA, leftJoinVarB, leftJoinVarC) -> bindingFunction.apply(this.extract(a), leftJoinVarA, leftJoinVarB, leftJoinVarC)));
    }

    @Override
    public final Child_ addDependentExpression(ViewItem<?> expression) {
        return this.create(expression);
    }

    @Override
    public final List<ViewItem<?>> build() {
        Stream prerequisites = this.prerequisiteExpressions.stream();
        Stream dependents = this.dependentExpressions.stream();
        return Stream.concat(Stream.concat(prerequisites, Stream.of(this.patternSupplier.get())), dependents).collect(Collectors.toList());
    }
}

