/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.EqualsAndComparisonIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.impl.score.stream.JoinerType;

class EqualsAndComparisonIndexerTest {
    EqualsAndComparisonIndexerTest() {
    }

    @Test
    void getEmpty() {
        EqualsAndComparisonIndexer indexer = new EqualsAndComparisonIndexer(JoinerType.LESS_THAN_OR_EQUAL);
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 40})).isEmpty();
    }

    @Test
    void putTwice() {
        EqualsAndComparisonIndexer indexer = new EqualsAndComparisonIndexer(JoinerType.LESS_THAN_OR_EQUAL);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        Assertions.assertThatThrownBy(() -> EqualsAndComparisonIndexerTest.lambda$putTwice$0((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void removeTwice() {
        EqualsAndComparisonIndexer indexer = new EqualsAndComparisonIndexer(JoinerType.LESS_THAN_OR_EQUAL);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        UniTuple<String> ednaTuple = EqualsAndComparisonIndexerTest.newTuple("Edna-F-40");
        Assertions.assertThatThrownBy(() -> EqualsAndComparisonIndexerTest.lambda$removeTwice$1((Indexer)indexer, ednaTuple)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThat((String)((String)indexer.remove(new Object[]{"F", 40}, annTuple))).isEqualTo("Ann value");
        Assertions.assertThatThrownBy(() -> EqualsAndComparisonIndexerTest.lambda$removeTwice$2((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void get() {
        EqualsAndComparisonIndexer indexer = new EqualsAndComparisonIndexer(JoinerType.LESS_THAN_OR_EQUAL);
        UniTuple<String> annTuple = EqualsAndComparisonIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        UniTuple<String> bethTuple = EqualsAndComparisonIndexerTest.newTuple("Beth-F-30");
        indexer.put(new Object[]{"F", 30}, bethTuple, (Object)"Beth value");
        indexer.put(new Object[]{"M", 40}, EqualsAndComparisonIndexerTest.newTuple("Carl-M-40"), (Object)"Carl value");
        indexer.put(new Object[]{"M", 30}, EqualsAndComparisonIndexerTest.newTuple("Dan-M-30"), (Object)"Dan value");
        UniTuple<String> ednaTuple = EqualsAndComparisonIndexerTest.newTuple("Edna-F-40");
        indexer.put(new Object[]{"F", 40}, ednaTuple, (Object)"Edna value");
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 40})).containsOnlyKeys((Object[])new UniTuple[]{annTuple, bethTuple, ednaTuple});
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 35})).containsOnlyKeys((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 30})).containsOnlyKeys((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 20})).isEmpty();
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTuple((Object)factA, 0);
    }

    private static /* synthetic */ void lambda$removeTwice$2(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.remove(new Object[]{"F", 40}, (Tuple)annTuple);
    }

    private static /* synthetic */ void lambda$removeTwice$1(Indexer indexer, UniTuple ednaTuple) throws Throwable {
        indexer.remove(new Object[]{"F", 40}, (Tuple)ednaTuple);
    }

    private static /* synthetic */ void lambda$putTwice$0(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.put(new Object[]{"F", 40}, (Tuple)annTuple, (Object)"Ann value");
    }
}

