/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.EqualsIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

class EqualsIndexerTest {
    EqualsIndexerTest() {
    }

    @Test
    void getEmpty() {
        EqualsIndexer indexer = new EqualsIndexer();
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 40})).isEmpty();
    }

    @Test
    void putTwice() {
        EqualsIndexer indexer = new EqualsIndexer();
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        Assertions.assertThatThrownBy(() -> EqualsIndexerTest.lambda$putTwice$0((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void removeTwice() {
        EqualsIndexer indexer = new EqualsIndexer();
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        UniTuple<String> ednaTuple = EqualsIndexerTest.newTuple("Edna-F-40");
        Assertions.assertThatThrownBy(() -> EqualsIndexerTest.lambda$removeTwice$1((Indexer)indexer, ednaTuple)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThat((String)((String)indexer.remove(new Object[]{"F", 40}, annTuple))).isEqualTo("Ann value");
        Assertions.assertThatThrownBy(() -> EqualsIndexerTest.lambda$removeTwice$2((Indexer)indexer, annTuple)).isInstanceOf(IllegalStateException.class);
    }

    @Test
    void get() {
        EqualsIndexer indexer = new EqualsIndexer();
        UniTuple<String> annTuple = EqualsIndexerTest.newTuple("Ann-F-40");
        indexer.put(new Object[]{"F", 40}, annTuple, (Object)"Ann value");
        UniTuple<String> bethTuple = EqualsIndexerTest.newTuple("Beth-F-30");
        indexer.put(new Object[]{"F", 30}, bethTuple, (Object)"Beth value");
        indexer.put(new Object[]{"M", 40}, EqualsIndexerTest.newTuple("Carl-M-40"), (Object)"Carl value");
        indexer.put(new Object[]{"M", 30}, EqualsIndexerTest.newTuple("Dan-M-30"), (Object)"Dan value");
        UniTuple<String> ednaTuple = EqualsIndexerTest.newTuple("Edna-F-40");
        indexer.put(new Object[]{"F", 40}, ednaTuple, (Object)"Edna value");
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 40})).containsOnlyKeys((Object[])new UniTuple[]{annTuple, ednaTuple});
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 30})).containsOnlyKeys((Object[])new UniTuple[]{bethTuple});
        Assertions.assertThat((Map)indexer.get(new Object[]{"F", 20})).isEmpty();
    }

    private static UniTuple<String> newTuple(String factA) {
        return new UniTuple((Object)factA, 0);
    }

    private static /* synthetic */ void lambda$removeTwice$2(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.remove(new Object[]{"F", 40}, (Tuple)annTuple);
    }

    private static /* synthetic */ void lambda$removeTwice$1(Indexer indexer, UniTuple ednaTuple) throws Throwable {
        indexer.remove(new Object[]{"F", 40}, (Tuple)ednaTuple);
    }

    private static /* synthetic */ void lambda$putTwice$0(Indexer indexer, UniTuple annTuple) throws Throwable {
        indexer.put(new Object[]{"F", 40}, (Tuple)annTuple, (Object)"Ann value");
    }
}

