/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintSession;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.uni.ForEachUniNode;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public final class BavetConstraintSessionFactory<Solution_, Score_ extends Score<Score_>> {
    private final SolutionDescriptor<Solution_> solutionDescriptor;
    private final List<BavetConstraint<Solution_>> constraintList;

    public BavetConstraintSessionFactory(SolutionDescriptor<Solution_> solutionDescriptor, List<BavetConstraint<Solution_>> constraintList) {
        this.solutionDescriptor = solutionDescriptor;
        this.constraintList = constraintList;
    }

    public BavetConstraintSession<Solution_, Score_> buildSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Object scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintMatchEnabled);
        Score zeroScore = scoreDefinition.getZeroScore();
        LinkedHashSet constraintStreamSet = new LinkedHashSet(this.constraintList.size() * 10);
        HashMap constraintWeightMap = new HashMap(this.constraintList.size());
        for (BavetConstraint constraint : this.constraintList) {
            Object constraintWeight = constraint.extractConstraintWeight(workingSolution);
            if (constraintWeight.equals(zeroScore)) continue;
            constraint.collectActiveConstraintStreams(constraintStreamSet);
            constraintWeightMap.put(constraint, constraintWeight);
        }
        NodeBuildHelper buildHelper = new NodeBuildHelper((Set<? extends ConstraintStream>)((Set<ConstraintStream>)constraintStreamSet), constraintWeightMap, scoreInliner);
        ArrayList reversedConstraintStreamList = new ArrayList(constraintStreamSet);
        Collections.reverse(reversedConstraintStreamList);
        for (BavetAbstractConstraintStream constraintStream : reversedConstraintStreamList) {
            constraintStream.buildNode(buildHelper);
        }
        List<AbstractNode> nodeList = buildHelper.destroyAndGetNodeList();
        LinkedHashMap declaredClassToNodeMap = new LinkedHashMap();
        for (AbstractNode node : nodeList) {
            ForEachUniNode forEachUniNode;
            ForEachUniNode<Object> old;
            if (!(node instanceof ForEachUniNode) || (old = declaredClassToNodeMap.put((forEachUniNode = (ForEachUniNode)node).getForEachClass(), forEachUniNode)) == null) continue;
            throw new IllegalStateException("Impossible state: For class (" + forEachUniNode.getForEachClass() + ") there are 2 nodes (" + forEachUniNode + ", " + old + ").");
        }
        return new BavetConstraintSession(scoreInliner, declaredClassToNodeMap, (AbstractNode[])nodeList.toArray(AbstractNode[]::new));
    }
}

