/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.JoinBiNode;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinBiConstraintStream<Solution_, A, B>
extends BavetAbstractBiConstraintStream<Solution_, A, B>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetAbstractUniConstraintStream<Solution_, A> leftParent;
    private final BavetAbstractUniConstraintStream<Solution_, B> rightParent;
    private final Function<A, Object[]> leftMapping;
    private final Function<B, Object[]> rightMapping;
    private final IndexerFactory indexerFactory;

    public BavetJoinBiConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> leftParent, BavetAbstractUniConstraintStream<Solution_, B> rightParent, Function<A, Object[]> leftMapping, Function<B, Object[]> rightMapping, IndexerFactory indexerFactory) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.leftMapping = leftMapping;
        this.rightMapping = rightMapping;
        this.indexerFactory = indexerFactory;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexA = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int inputStoreIndexB = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        Indexer indexerA = this.indexerFactory.buildIndexer(true);
        Indexer indexerB = this.indexerFactory.buildIndexer(false);
        JoinBiNode<A, B> node = new JoinBiNode<A, B>(this.leftMapping, this.rightMapping, inputStoreIndexA, inputStoreIndexB, insert, retract, outputStoreSize, indexerA, indexerB);
        buildHelper.addNode(node);
        buildHelper.putInsertRetract(this.leftParent, node::insertA, node::retractA);
        buildHelper.putInsertRetract(this.rightParent, node::insertB, node::retractB);
    }

    public String toString() {
        return "BiJoin() with " + this.childStreamList.size() + " children";
    }
}

