/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.bi.BiConstraintCollector;

public final class GroupBiToBiNode<OldA, OldB, A, B, ResultContainer_>
extends AbstractNode {
    private final BiFunction<OldA, OldB, A> groupKeyMapping;
    private final int groupStoreIndex;
    private final Supplier<ResultContainer_> supplier;
    private final TriFunction<ResultContainer_, OldA, OldB, Runnable> accumulator;
    private final Function<ResultContainer_, B> finisher;
    private final Consumer<BiTuple<A, B>> nextNodesInsert;
    private final Consumer<BiTuple<A, B>> nextNodesRetract;
    private final int outputStoreSize;
    private final Map<A, Group> groupMap;
    private final Queue<Group> dirtyGroupQueue;

    public GroupBiToBiNode(BiFunction<OldA, OldB, A> groupKeyMapping, int groupStoreIndex, BiConstraintCollector<OldA, OldB, ResultContainer_, B> collector, Consumer<BiTuple<A, B>> nextNodesInsert, Consumer<BiTuple<A, B>> nextNodesRetract, int outputStoreSize) {
        this.groupKeyMapping = groupKeyMapping;
        this.groupStoreIndex = groupStoreIndex;
        this.supplier = collector.supplier();
        this.accumulator = collector.accumulator();
        this.finisher = collector.finisher();
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.outputStoreSize = outputStoreSize;
        this.groupMap = new HashMap<A, Group>(1000);
        this.dirtyGroupQueue = new ArrayDeque<Group>(1000);
    }

    public void insertAB(BiTuple<OldA, OldB> tupleOldAB) {
        if (tupleOldAB.store[this.groupStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the tuple for the fact (" + tupleOldAB.factA + ", " + tupleOldAB.factB + ") was already added in the groupStore.");
        }
        A groupKey = this.groupKeyMapping.apply(tupleOldAB.factA, tupleOldAB.factB);
        Group group = this.groupMap.computeIfAbsent(groupKey, k -> new Group(groupKey, this.supplier.get()));
        ++group.parentCount;
        Runnable undoAccumulator = (Runnable)this.accumulator.apply(group.resultContainer, tupleOldAB.factA, tupleOldAB.factB);
        GroupPart groupPart = new GroupPart(group, undoAccumulator);
        tupleOldAB.store[this.groupStoreIndex] = groupPart;
        if (!group.dirty) {
            group.dirty = true;
            this.dirtyGroupQueue.add(group);
        }
    }

    public void retractAB(BiTuple<OldA, OldB> tupleOldAB) {
        GroupPart groupPart = (GroupPart)tupleOldAB.store[this.groupStoreIndex];
        if (groupPart == null) {
            return;
        }
        tupleOldAB.store[this.groupStoreIndex] = null;
        Group group = groupPart.group;
        --group.parentCount;
        groupPart.undoAccumulator.run();
        if (group.parentCount == 0) {
            Group old = this.groupMap.remove(group.groupKey);
            if (old == null) {
                throw new IllegalStateException("Impossible state: the group for the groupKey (" + group.groupKey + ") doesn't exist in the groupMap.");
            }
            group.dying = true;
        }
        if (!group.dirty) {
            group.dirty = true;
            this.dirtyGroupQueue.add(group);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyGroupQueue.forEach(group -> {
            group.dirty = false;
            if (group.tupleAB != null) {
                if (group.tupleAB.state != BavetTupleState.OK) {
                    throw new IllegalStateException("Impossible state: The tuple (" + group.tupleAB + ") in node (" + this + ") is in the state (" + group.tupleAB.state + ").");
                }
                group.tupleAB.state = BavetTupleState.DYING;
                this.nextNodesRetract.accept(group.tupleAB);
                group.tupleAB.state = BavetTupleState.DEAD;
            }
            if (!group.dying) {
                B factB = this.finisher.apply(group.resultContainer);
                group.tupleAB = new BiTuple(group.groupKey, factB, this.outputStoreSize);
                this.nextNodesInsert.accept(group.tupleAB);
                group.tupleAB.state = BavetTupleState.OK;
            }
        });
        this.dirtyGroupQueue.clear();
    }

    public String toString() {
        return "GroupBiToBiNode";
    }

    private final class GroupPart {
        Group group;
        Runnable undoAccumulator;

        public GroupPart(Group group, Runnable undoAccumulator) {
            this.group = group;
            this.undoAccumulator = undoAccumulator;
        }
    }

    private final class Group {
        A groupKey;
        ResultContainer_ resultContainer;
        int parentCount = 0;
        boolean dirty = false;
        boolean dying = false;
        BiTuple<A, B> tupleAB = null;

        public Group(A groupKey, ResultContainer_ resultContainer) {
            this.groupKey = groupKey;
            this.resultContainer = resultContainer;
        }
    }
}

