/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.Set;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.BavetConstraint;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetScoringConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.common.AbstractConstraintStream;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public abstract class BavetAbstractConstraintStream<Solution_>
extends AbstractConstraintStream<Solution_> {
    protected final BavetConstraintFactory<Solution_> constraintFactory;

    public BavetAbstractConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(retrievalSemantics);
        this.constraintFactory = constraintFactory;
    }

    protected BavetConstraint<Solution_> buildConstraint(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType, BavetScoringConstraintStream<Solution_> scoringConstraintStream) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName, constraintWeight);
        BavetConstraint<Solution_> constraint = new BavetConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, impactType, false, scoringConstraintStream);
        scoringConstraintStream.setConstraint(constraint);
        return constraint;
    }

    protected BavetConstraint<Solution_> buildConstraintConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType, BavetScoringConstraintStream<Solution_> scoringConstraintStream) {
        Function constraintWeightExtractor = this.buildConstraintWeightExtractor(constraintPackage, constraintName);
        BavetConstraint<Solution_> constraint = new BavetConstraint<Solution_>(this.constraintFactory, constraintPackage, constraintName, constraintWeightExtractor, impactType, true, scoringConstraintStream);
        scoringConstraintStream.setConstraint(constraint);
        return constraint;
    }

    public abstract void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> var1);

    public abstract ConstraintStream getTupleSource();

    public abstract <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> var1);

    @Override
    public BavetConstraintFactory<Solution_> getConstraintFactory() {
        return this.constraintFactory;
    }
}

