/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerKey;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class EqualsAndComparisonIndexer<Tuple_ extends Tuple, Value_>
implements Indexer<Tuple_, Value_> {
    private final JoinerType comparisonJoinerType;
    private final Map<IndexerKey, NavigableMap<Object, Map<Tuple_, Value_>>> equalsMap = new HashMap<IndexerKey, NavigableMap<Object, Map<Tuple_, Value_>>>();

    public EqualsAndComparisonIndexer(JoinerType comparisonJoinerType) {
        this.comparisonJoinerType = comparisonJoinerType;
    }

    @Override
    public void put(Object[] indexProperties, Tuple_ tuple, Value_ value) {
        Objects.requireNonNull(value);
        int indexPropertyCount = indexProperties.length;
        IndexerKey equalsIndexKey = new IndexerKey(indexProperties, indexPropertyCount - 1);
        Object comparisonIndexProperty = indexProperties[indexPropertyCount - 1];
        NavigableMap comparisonMap = this.equalsMap.computeIfAbsent(equalsIndexKey, k -> new TreeMap());
        Map tupleMap = comparisonMap.computeIfAbsent(comparisonIndexProperty, k -> new LinkedHashMap());
        Value_ old = tupleMap.put(tuple, value);
        if (old != null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") was already added in the indexer.");
        }
    }

    @Override
    public Value_ remove(Object[] indexProperties, Tuple_ tuple) {
        int indexPropertyCount = indexProperties.length;
        IndexerKey equalsIndexKey = new IndexerKey(indexProperties, indexPropertyCount - 1);
        NavigableMap<Object, Map<Tuple_, Value_>> comparisonMap = this.equalsMap.get(equalsIndexKey);
        if (comparisonMap == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        Object comparisonIndexProperty = indexProperties[indexPropertyCount - 1];
        Map tupleMap = (Map)comparisonMap.get(comparisonIndexProperty);
        if (tupleMap == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        Object value = tupleMap.remove(tuple);
        if (value == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        if (tupleMap.isEmpty()) {
            comparisonMap.remove(comparisonIndexProperty);
            if (comparisonMap.isEmpty()) {
                this.equalsMap.remove(equalsIndexKey);
            }
        }
        return (Value_)value;
    }

    @Override
    public Map<Tuple_, Value_> get(Object[] indexProperties) {
        NavigableMap<Object, Map<Tuple_, Value_>> selectedComparisonMap;
        int indexPropertyCount = indexProperties.length;
        IndexerKey equalsIndexKey = new IndexerKey(indexProperties, indexPropertyCount - 1);
        NavigableMap<Object, Map<Tuple_, Value_>> comparisonMap = this.equalsMap.get(equalsIndexKey);
        if (comparisonMap == null) {
            return Collections.emptyMap();
        }
        Object comparisonIndexProperty = indexProperties[indexPropertyCount - 1];
        switch (this.comparisonJoinerType) {
            case LESS_THAN: {
                selectedComparisonMap = comparisonMap.headMap(comparisonIndexProperty, false);
                break;
            }
            case LESS_THAN_OR_EQUAL: {
                selectedComparisonMap = comparisonMap.headMap(comparisonIndexProperty, true);
                break;
            }
            case GREATER_THAN: {
                selectedComparisonMap = comparisonMap.tailMap(comparisonIndexProperty, false);
                break;
            }
            case GREATER_THAN_OR_EQUAL: {
                selectedComparisonMap = comparisonMap.tailMap(comparisonIndexProperty, true);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the comparisonJoinerType (" + this.comparisonJoinerType + ") is not one of the 4 comparison types.");
            }
        }
        if (selectedComparisonMap.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Map map : selectedComparisonMap.values()) {
            result.putAll(map);
        }
        return result;
    }
}

