/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerKey;

public final class EqualsIndexer<Tuple_ extends Tuple, Value_>
implements Indexer<Tuple_, Value_> {
    private final Map<IndexerKey, Map<Tuple_, Value_>> map = new HashMap<IndexerKey, Map<Tuple_, Value_>>();

    @Override
    public void put(Object[] indexProperties, Tuple_ tuple, Value_ value) {
        Objects.requireNonNull(value);
        Map tupleMap = this.map.computeIfAbsent(new IndexerKey(indexProperties), k -> new LinkedHashMap());
        Value_ old = tupleMap.put(tuple, value);
        if (old != null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") was already added in the indexer.");
        }
    }

    @Override
    public Value_ remove(Object[] indexProperties, Tuple_ tuple) {
        IndexerKey oldIndexKey = new IndexerKey(indexProperties);
        Map<Tuple_, Value_> tupleMap = this.map.get(oldIndexKey);
        if (tupleMap == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        Value_ value = tupleMap.remove(tuple);
        if (value == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        if (tupleMap.isEmpty()) {
            this.map.remove(oldIndexKey);
        }
        return value;
    }

    @Override
    public Map<Tuple_, Value_> get(Object[] indexProperties) {
        Map<Tuple_, Value_> tupleMap = this.map.get(new IndexerKey(indexProperties));
        if (tupleMap == null) {
            return Collections.emptyMap();
        }
        return tupleMap;
    }
}

