/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.EqualsAndComparisonIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.EqualsIndexer;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.NoneIndexer;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public class IndexerFactory {
    private final JoinerType[] joinerTypes;

    public IndexerFactory(AbstractJoiner joiner) {
        int joinerCount = joiner.getJoinerCount();
        this.joinerTypes = new JoinerType[joinerCount];
        for (int i = 0; i < joinerCount; ++i) {
            JoinerType joinerType = joiner.getJoinerType(i);
            switch (joinerType) {
                case EQUAL: 
                case LESS_THAN: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_OR_EQUAL: {
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported joiner type (" + joinerType + ").");
                }
            }
            if (joinerType != JoinerType.EQUAL && i != joinerCount - 1) {
                JoinerType nextJoinerType = joiner.getJoinerType(i + 1);
                throw new IllegalArgumentException("The joinerType (" + joinerType + ") is currently only supported as the last joinerType.\n" + (nextJoinerType == JoinerType.EQUAL ? "Maybe move the next joinerType (" + nextJoinerType + ") before this joinerType (" + joinerType + ")." : "Maybe put the next joinerType (" + nextJoinerType + ") in a filter() predicate after the join() call for now."));
            }
            this.joinerTypes[i] = joiner.getJoinerType(i);
        }
    }

    public <Tuple_ extends Tuple, Value_> Indexer<Tuple_, Value_> buildIndexer(boolean isLeftBridge) {
        if (this.joinerTypes.length == 0) {
            return new NoneIndexer();
        }
        JoinerType lastJoinerType = this.joinerTypes[this.joinerTypes.length - 1];
        if (lastJoinerType == JoinerType.EQUAL) {
            return new EqualsIndexer();
        }
        return new EqualsAndComparisonIndexer(isLeftBridge ? lastJoinerType : lastJoinerType.flip());
    }
}

