/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;

public final class NoneIndexer<Tuple_ extends Tuple, Value_>
implements Indexer<Tuple_, Value_> {
    private final Map<Tuple_, Value_> tupleMap = new LinkedHashMap<Tuple_, Value_>();

    @Override
    public void put(Object[] indexProperties, Tuple_ tuple, Value_ value) {
        Objects.requireNonNull(value);
        Value_ old = this.tupleMap.put(tuple, value);
        if (old != null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") was already added in the indexer.");
        }
    }

    @Override
    public Value_ remove(Object[] indexProperties, Tuple_ tuple) {
        Value_ value = this.tupleMap.remove(tuple);
        if (value == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + Arrays.toString(indexProperties) + ") doesn't exist in the indexer.");
        }
        return value;
    }

    @Override
    public Map<Tuple_, Value_> get(Object[] indexProperties) {
        return this.tupleMap;
    }
}

