/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetAbstractBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetJoinConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.tri.BavetAbstractTriConstraintStream;
import org.optaplanner.constraint.streams.bavet.tri.JoinTriNode;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetJoinTriConstraintStream<Solution_, A, B, C>
extends BavetAbstractTriConstraintStream<Solution_, A, B, C>
implements BavetJoinConstraintStream<Solution_> {
    private final BavetAbstractBiConstraintStream<Solution_, A, B> leftParent;
    private final BavetAbstractUniConstraintStream<Solution_, C> rightParent;
    private final BiFunction<A, B, Object[]> leftMapping;
    private final Function<C, Object[]> rightMapping;
    private final IndexerFactory indexerFactory;

    public BavetJoinTriConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractBiConstraintStream<Solution_, A, B> leftParent, BavetAbstractUniConstraintStream<Solution_, C> rightParent, BiFunction<A, B, Object[]> leftMapping, Function<C, Object[]> rightMapping, IndexerFactory indexerFactory) {
        super(constraintFactory, leftParent.getRetrievalSemantics());
        this.leftParent = leftParent;
        this.rightParent = rightParent;
        this.leftMapping = leftMapping;
        this.rightMapping = rightMapping;
        this.indexerFactory = indexerFactory;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.leftParent.guaranteesDistinct() && this.rightParent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.leftParent.collectActiveConstraintStreams(constraintStreamSet);
        this.rightParent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this;
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexAB = buildHelper.reserveTupleStoreIndex(this.leftParent.getTupleSource());
        int inputStoreIndexC = buildHelper.reserveTupleStoreIndex(this.rightParent.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        int outputStoreSize = buildHelper.extractTupleStoreSize(this);
        Indexer indexerAB = this.indexerFactory.buildIndexer(true);
        Indexer indexerC = this.indexerFactory.buildIndexer(false);
        JoinTriNode<A, B, C> node = new JoinTriNode<A, B, C>(this.leftMapping, this.rightMapping, inputStoreIndexAB, inputStoreIndexC, insert, retract, outputStoreSize, indexerAB, indexerC);
        buildHelper.addNode(node);
        buildHelper.putInsertRetract(this.leftParent, node::insertAB, node::retractAB);
        buildHelper.putInsertRetract(this.rightParent, node::insertC, node::retractC);
    }

    public String toString() {
        return "TriJoin() with " + this.childStreamList.size() + " children";
    }
}

