/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import org.optaplanner.constraint.streams.bavet.common.AbstractScorer;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.Score;

public final class TriScorer<A, B, C>
extends AbstractScorer {
    private final String constraintPackage;
    private final String constraintName;
    private final Score<?> constraintWeight;
    private final TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter;
    private final int inputStoreIndex;

    public TriScorer(String constraintPackage, String constraintName, Score<?> constraintWeight, TriFunction<A, B, C, UndoScoreImpacter> scoreImpacter, int inputStoreIndex) {
        this.constraintPackage = constraintPackage;
        this.constraintName = constraintName;
        this.constraintWeight = constraintWeight;
        this.scoreImpacter = scoreImpacter;
        this.inputStoreIndex = inputStoreIndex;
    }

    public void insert(TriTuple<A, B, C> tupleABC) {
        if (tupleABC.store[this.inputStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the tuple for the facts (" + tupleABC.factA + ", " + tupleABC.factB + ", " + tupleABC.factC + ") was already added in the scorerStore.");
        }
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)this.scoreImpacter.apply(tupleABC.factA, tupleABC.factB, tupleABC.factC);
        tupleABC.store[this.inputStoreIndex] = undoScoreImpacter;
    }

    public void retract(TriTuple<A, B, C> tupleABC) {
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tupleABC.store[this.inputStoreIndex];
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            tupleABC.store[this.inputStoreIndex] = null;
        }
    }

    public String toString() {
        return "Scorer(" + this.constraintName + ") with constraintWeight (" + this.constraintWeight + ")";
    }
}

