/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.bi.BavetGroupBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.bi.BavetJoinBiConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.uni.BavetFilterUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetGroupBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetJoinBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetScoringUniConstraintStream;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.constraint.streams.bi.FilteringBiJoiner;
import org.optaplanner.constraint.streams.common.RetrievalSemantics;
import org.optaplanner.constraint.streams.common.ScoreImpactType;
import org.optaplanner.constraint.streams.uni.InnerUniConstraintStream;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.bi.BiConstraintStream;
import org.optaplanner.core.api.score.stream.bi.BiJoiner;
import org.optaplanner.core.api.score.stream.quad.QuadConstraintStream;
import org.optaplanner.core.api.score.stream.tri.TriConstraintStream;
import org.optaplanner.core.api.score.stream.uni.UniConstraintCollector;
import org.optaplanner.core.api.score.stream.uni.UniConstraintStream;

public abstract class BavetAbstractUniConstraintStream<Solution_, A>
extends BavetAbstractConstraintStream<Solution_>
implements InnerUniConstraintStream<A> {
    protected final List<BavetAbstractUniConstraintStream<Solution_, A>> childStreamList = new ArrayList<BavetAbstractUniConstraintStream<Solution_, A>>(2);

    public BavetAbstractUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, RetrievalSemantics retrievalSemantics) {
        super(constraintFactory, retrievalSemantics);
    }

    public List<BavetAbstractUniConstraintStream<Solution_, A>> getChildStreamList() {
        return this.childStreamList;
    }

    public <Stream_ extends BavetAbstractUniConstraintStream<Solution_, A>> Stream_ shareAndAddChild(Stream_ stream) {
        return (Stream_)this.constraintFactory.share(stream, this.childStreamList::add);
    }

    public BavetAbstractUniConstraintStream<Solution_, A> filter(Predicate<A> predicate) {
        return this.shareAndAddChild(new BavetFilterUniConstraintStream(this.constraintFactory, this, predicate));
    }

    public <B> BiConstraintStream<A, B> join(UniConstraintStream<B> otherStream, BiJoiner<A, B> joiner) {
        if (!(otherStream instanceof BavetAbstractUniConstraintStream)) {
            throw new IllegalStateException("The streams (" + this + ", " + otherStream + ") are not build from the same " + ConstraintFactory.class.getSimpleName() + ".");
        }
        BavetAbstractUniConstraintStream other = (BavetAbstractUniConstraintStream)otherStream;
        if (this.constraintFactory != other.getConstraintFactory()) {
            throw new IllegalStateException("The streams (" + this + ", " + other + ") are build from different constraintFactories (" + this.constraintFactory + ", " + (BavetConstraintFactory)other.getConstraintFactory() + ").");
        }
        if (joiner instanceof FilteringBiJoiner) {
            return this.join(otherStream).filter(((FilteringBiJoiner)joiner).getFilter());
        }
        if (!(joiner instanceof DefaultBiJoiner)) {
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        DefaultBiJoiner castedJoiner = (DefaultBiJoiner)joiner;
        IndexerFactory indexerFactory = new IndexerFactory(castedJoiner);
        Function leftMapping = JoinerUtils.combineLeftMappings(castedJoiner);
        BavetJoinBridgeUniConstraintStream leftBridge = this.shareAndAddChild(new BavetJoinBridgeUniConstraintStream(this.constraintFactory, this, true));
        Function rightMapping = JoinerUtils.combineRightMappings(castedJoiner);
        BavetJoinBridgeUniConstraintStream rightBridge = other.shareAndAddChild(new BavetJoinBridgeUniConstraintStream(this.constraintFactory, other, false));
        return this.constraintFactory.share(new BavetJoinBiConstraintStream(this.constraintFactory, leftBridge, rightBridge, leftMapping, rightMapping, indexerFactory), joinStream_ -> {
            leftBridge.setJoinStream(joinStream_);
            rightBridge.setJoinStream(joinStream_);
        });
    }

    @Override
    public <B> BiConstraintStream<A, B> join(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        if (this.getRetrievalSemantics() == RetrievalSemantics.STANDARD) {
            return this.join(this.constraintFactory.forEach(otherClass), joiners);
        }
        return this.join(this.constraintFactory.from(otherClass), joiners);
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifExists(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifNotExists(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final <B> UniConstraintStream<A> ifNotExistsIncludingNullVars(Class<B> otherClass, BiJoiner<A, B> ... joiners) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainer_, Result_> UniConstraintStream<Result_> groupBy(UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_> BiConstraintStream<ResultA_, ResultB_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<ResultA_, ResultB_, ResultC_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <ResultContainerA_, ResultA_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<ResultA_, ResultB_, ResultC_, ResultD_> groupBy(UniConstraintCollector<A, ResultContainerA_, ResultA_> collectorA, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_> UniConstraintStream<GroupKey_> groupBy(Function<A, GroupKey_> groupKeyMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_> TriConstraintStream<GroupKey_, ResultB_, ResultC_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainerB_, ResultB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKey_, ResultB_, ResultC_, ResultD_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainerB_, ResultB_> collectorB, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_> BiConstraintStream<GroupKeyA_, GroupKeyB_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKey_, ResultContainer_, Result_> BiConstraintStream<GroupKey_, Result_> groupBy(Function<A, GroupKey_> groupKeyMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        BavetGroupBridgeUniConstraintStream bridge = this.shareAndAddChild(new BavetGroupBridgeUniConstraintStream(this.constraintFactory, this, groupKeyMapping, collector));
        return this.constraintFactory.share(new BavetGroupBiConstraintStream(this.constraintFactory, bridge), bridge::setGroupStream);
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainer_, Result_> TriConstraintStream<GroupKeyA_, GroupKeyB_, Result_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, UniConstraintCollector<A, ResultContainer_, Result_> collector) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, ResultContainerC_, ResultC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, ResultC_, ResultD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, UniConstraintCollector<A, ResultContainerC_, ResultC_> collectorC, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_> TriConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultContainerD_, ResultD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, ResultD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping, UniConstraintCollector<A, ResultContainerD_, ResultD_> collectorD) {
        throw new UnsupportedOperationException();
    }

    public <GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> QuadConstraintStream<GroupKeyA_, GroupKeyB_, GroupKeyC_, GroupKeyD_> groupBy(Function<A, GroupKeyA_> groupKeyAMapping, Function<A, GroupKeyB_> groupKeyBMapping, Function<A, GroupKeyC_> groupKeyCMapping, Function<A, GroupKeyD_> groupKeyDMapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultA_> UniConstraintStream<ResultA_> map(Function<A, ResultA_> mapping) {
        throw new UnsupportedOperationException();
    }

    public <ResultA_> UniConstraintStream<ResultA_> flattenLast(Function<A, Iterable<ResultA_>> mapping) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this));
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, stream);
    }

    @Override
    public final Constraint impactScore(String constraintPackage, String constraintName, Score<?> constraintWeight, ToIntFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, stream);
    }

    @Override
    public final Constraint impactScoreLong(String constraintPackage, String constraintName, Score<?> constraintWeight, ToLongFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, stream);
    }

    @Override
    public final Constraint impactScoreBigDecimal(String constraintPackage, String constraintName, Score<?> constraintWeight, Function<A, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraint(constraintPackage, constraintName, constraintWeight, impactType, stream);
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this));
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, stream);
    }

    @Override
    public final Constraint impactScoreConfigurable(String constraintPackage, String constraintName, ToIntFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, stream);
    }

    @Override
    public final Constraint impactScoreConfigurableLong(String constraintPackage, String constraintName, ToLongFunction<A> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, stream);
    }

    @Override
    public final Constraint impactScoreConfigurableBigDecimal(String constraintPackage, String constraintName, Function<A, BigDecimal> matchWeigher, ScoreImpactType impactType) {
        BavetScoringUniConstraintStream stream = this.shareAndAddChild(new BavetScoringUniConstraintStream(this.constraintFactory, this, matchWeigher));
        return this.buildConstraintConfigurable(constraintPackage, constraintName, impactType, stream);
    }
}

