/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public final class ForEachUniNode<A>
extends AbstractNode {
    private final Class<A> forEachClass;
    private final Consumer<UniTuple<A>> nextNodesInsert;
    private final Consumer<UniTuple<A>> nextNodesRetract;
    private final int outputStoreSize;
    private final Map<A, UniTuple<A>> tupleMap = new IdentityHashMap<A, UniTuple<A>>(1000);
    private final Queue<UniTuple<A>> dirtyTupleQueue;

    public ForEachUniNode(Class<A> forEachClass, Consumer<UniTuple<A>> nextNodesInsert, Consumer<UniTuple<A>> nextNodesRetract, int outputStoreSize) {
        this.forEachClass = forEachClass;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.outputStoreSize = outputStoreSize;
        this.dirtyTupleQueue = new ArrayDeque<UniTuple<A>>(1000);
    }

    public void insert(A a) {
        UniTuple<A> tuple = new UniTuple<A>(a, this.outputStoreSize);
        tuple.state = BavetTupleState.CREATING;
        UniTuple<A> old = this.tupleMap.put(a, tuple);
        if (old != null) {
            throw new IllegalStateException("The fact (" + a + ") was already inserted, so it cannot insert again.");
        }
        this.dirtyTupleQueue.add(tuple);
    }

    public void update(A a) {
        UniTuple<A> tuple = this.tupleMap.get(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (" + a + ") was never inserted, so it cannot update.");
        }
        if (tuple.state.isDirty()) {
            if (tuple.state == BavetTupleState.DYING || tuple.state == BavetTupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was retracted, so it cannot update.");
            }
            return;
        }
        tuple.state = BavetTupleState.UPDATING;
        this.dirtyTupleQueue.add(tuple);
    }

    public void retract(A a) {
        UniTuple<A> tuple = this.tupleMap.remove(a);
        if (tuple == null) {
            throw new IllegalStateException("The fact (" + a + ") was never inserted, so it cannot retract.");
        }
        if (tuple.state.isDirty()) {
            if (tuple.state == BavetTupleState.DYING || tuple.state == BavetTupleState.ABORTING) {
                throw new IllegalStateException("The fact (" + a + ") was already retracted, so it cannot retract.");
            }
            tuple.state = BavetTupleState.ABORTING;
        } else {
            tuple.state = BavetTupleState.DYING;
            this.dirtyTupleQueue.add(tuple);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyTupleQueue.forEach(tuple -> {
            if (tuple.state == BavetTupleState.UPDATING || tuple.state == BavetTupleState.DYING) {
                this.nextNodesRetract.accept((UniTuple<A>)tuple);
            }
            if (tuple.state == BavetTupleState.CREATING || tuple.state == BavetTupleState.UPDATING) {
                this.nextNodesInsert.accept((UniTuple<A>)tuple);
            }
            switch (tuple.state) {
                case CREATING: 
                case UPDATING: {
                    tuple.state = BavetTupleState.OK;
                    return;
                }
                case DYING: 
                case ABORTING: {
                    tuple.state = BavetTupleState.DEAD;
                    return;
                }
                case DEAD: {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is already in the dead state (" + tuple.state + ").");
                }
            }
            throw new IllegalStateException("Impossible state: Tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + tuple.state + ").");
        });
        this.dirtyTupleQueue.clear();
    }

    public String toString() {
        return "ForEachUniNode(" + this.forEachClass.getSimpleName() + ")";
    }

    public Class<A> getForEachClass() {
        return this.forEachClass;
    }
}

