/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.tri;

import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.optaplanner.constraint.streams.common.AbstractJoiner;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.stream.JoinerType;

public final class DefaultTriJoiner<A, B, C>
extends AbstractJoiner<C>
implements TriJoiner<A, B, C> {
    public static final TriJoiner NONE = new DefaultTriJoiner(new BiFunction[0], new JoinerType[0], new Function[0]);
    private final BiFunction<A, B, ?>[] leftMappings;

    public <Property_> DefaultTriJoiner(BiFunction<A, B, Property_> leftMapping, JoinerType joinerType, Function<C, Property_> rightMapping) {
        super(rightMapping, joinerType);
        this.leftMappings = new BiFunction[]{leftMapping};
    }

    private <Property_> DefaultTriJoiner(BiFunction<A, B, Property_>[] leftMappings, JoinerType[] joinerTypes, Function<C, Property_>[] rightMappings) {
        super(rightMappings, joinerTypes);
        this.leftMappings = leftMappings;
    }

    public DefaultTriJoiner<A, B, C> and(TriJoiner<A, B, C> otherJoiner) {
        DefaultTriJoiner castJoiner = (DefaultTriJoiner)otherJoiner;
        int joinerCount = this.getJoinerCount();
        int castJoinerCount = castJoiner.getJoinerCount();
        int newJoinerCount = joinerCount + castJoinerCount;
        JoinerType[] newJoinerTypes = Arrays.copyOf(this.joinerTypes, newJoinerCount);
        BiFunction<A, B, ?>[] newLeftMappings = Arrays.copyOf(this.leftMappings, newJoinerCount);
        Function[] newRightMappings = Arrays.copyOf(this.rightMappings, newJoinerCount);
        for (int i = 0; i < castJoinerCount; ++i) {
            int newJoinerIndex = i + joinerCount;
            newJoinerTypes[newJoinerIndex] = castJoiner.getJoinerType(i);
            newLeftMappings[newJoinerIndex] = castJoiner.getLeftMapping(i);
            newRightMappings[newJoinerIndex] = castJoiner.getRightMapping(i);
        }
        return new DefaultTriJoiner<A, B, C>(newLeftMappings, newJoinerTypes, newRightMappings);
    }

    public BiFunction<A, B, Object> getLeftMapping(int index) {
        return this.leftMappings[index];
    }

    public boolean matches(A a, B b, C c) {
        int joinerCount = this.getJoinerCount();
        for (int i = 0; i < joinerCount; ++i) {
            Object rightMapping;
            Object leftMapping;
            JoinerType joinerType = this.getJoinerType(i);
            if (joinerType.matches(leftMapping = this.getLeftMapping(i).apply(a, b), rightMapping = this.getRightMapping(i).apply(c))) continue;
            return false;
        }
        return true;
    }
}

