/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bi;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.optaplanner.constraint.streams.AbstractConstraintStreamTest;
import org.optaplanner.constraint.streams.ConstraintStreamFunctionalTest;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;
import org.optaplanner.core.impl.score.director.InnerScoreDirector;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntity;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishEntityGroup;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishExtra;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishSolution;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValue;
import org.optaplanner.core.impl.testdata.domain.score.lavish.TestdataLavishValueGroup;

class BiConstraintStreamTest
extends AbstractConstraintStreamTest
implements ConstraintStreamFunctionalTest {
    public BiConstraintStreamTest(boolean constraintMatchEnabled, ConstraintStreamImplType constraintStreamImplType) {
        super(constraintMatchEnabled, constraintStreamImplType);
    }

    @Override
    @TestTemplate
    public void filter_entity() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).filter((entity, value) -> value.getCode().equals("MyValue 1")).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1), BiConstraintStreamTest.assertMatch(entity3, value1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity3);
        entity3.setValue(value2);
        scoreDirector.afterProblemPropertyChanged((Object)entity3);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1));
        scoreDirector.beforeProblemPropertyChanged((Object)entity2);
        entity2.setValue(value1);
        scoreDirector.afterProblemPropertyChanged((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1), BiConstraintStreamTest.assertMatch(entity2, value1));
    }

    @Override
    @TestTemplate
    public void filter_consecutive() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)5, (int)5);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        TestdataLavishEntity entity4 = (TestdataLavishEntity)solution.getEntityList().get(3);
        TestdataLavishEntity entity5 = (TestdataLavishEntity)solution.getEntityList().get(4);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.filtering((entityA, entityB) -> !Objects.equals(entityA, entity1))).filter((entityA, entityB) -> !Objects.equals(entityA, entity2)).filter((entityA, entityB) -> !Objects.equals(entityA, entity3)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity4, entity5));
        scoreDirector.beforeEntityRemoved((Object)entity4);
        solution.getEntityList().remove(entity4);
        scoreDirector.afterEntityRemoved((Object)entity4);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_0() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).join(TestdataLavishExtra.class).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra2), BiConstraintStreamTest.assertMatch(entity1, value1, extra3), BiConstraintStreamTest.assertMatch(entity2, value2, extra1), BiConstraintStreamTest.assertMatch(entity2, value2, extra2), BiConstraintStreamTest.assertMatch(entity2, value2, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra2), BiConstraintStreamTest.assertMatch(entity1, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_1Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        extra1.setStringProperty("MyString");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        extra2.setStringProperty(null);
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        extra3.setStringProperty("MyString");
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).join(TestdataLavishExtra.class, Joiners.equal((entity, value) -> entity.getStringProperty(), TestdataLavishExtra::getStringProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra3), BiConstraintStreamTest.assertMatch(entity2, value2, extra2));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    public void join_1Filtering() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        extra1.setStringProperty("MyString");
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        extra2.setStringProperty(null);
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        extra3.setStringProperty("MyString");
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.filtering((entity, value) -> Objects.equals(entity.getValue(), value))).join(TestdataLavishExtra.class, Joiners.equal((entity, value) -> entity.getStringProperty(), TestdataLavishExtra::getStringProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra3), BiConstraintStreamTest.assertMatch(entity2, value2, extra2));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra1), BiConstraintStreamTest.assertMatch(entity1, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void join_2Equal() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        entity1.setIntegerProperty(Integer.valueOf(7));
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        entity2.setIntegerProperty(Integer.valueOf(8));
        solution.getEntityList().add(entity2);
        TestdataLavishExtra extra1 = new TestdataLavishExtra("MyExtra 1");
        extra1.setStringProperty("MyString");
        extra1.setIntegerProperty(Integer.valueOf(8));
        solution.getExtraList().add(extra1);
        TestdataLavishExtra extra2 = new TestdataLavishExtra("MyExtra 2");
        extra2.setStringProperty(null);
        extra2.setIntegerProperty(Integer.valueOf(7));
        solution.getExtraList().add(extra2);
        TestdataLavishExtra extra3 = new TestdataLavishExtra("MyExtra 3");
        extra3.setStringProperty("MyString");
        extra3.setIntegerProperty(Integer.valueOf(7));
        solution.getExtraList().add(extra3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).join(TestdataLavishExtra.class, Joiners.equal((entity, value) -> entity.getStringProperty(), TestdataLavishExtra::getStringProperty), Joiners.equal((entity, value) -> entity.getIntegerProperty(), TestdataLavishExtra::getIntegerProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1, extra3));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @TestTemplate
    public void join_filtering_comesLast() {
        Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.filtering((a, b) -> false), Joiners.equal(TestdataLavishEntity::getValue, Function.identity())).join(TestdataLavishExtra.class).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalStateException.class);
    }

    @TestTemplate
    public void join_mixedEqualsAndFiltering() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)0, (int)1, (int)0);
        TestdataLavishValue value1 = new TestdataLavishValue("MyValue 1", solution.getFirstValueGroup());
        solution.getValueList().add(value1);
        TestdataLavishValue value2 = new TestdataLavishValue("MyValue 2", solution.getFirstValueGroup());
        solution.getValueList().add(value2);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", solution.getFirstEntityGroup(), value1);
        entity1.setStringProperty("MyString");
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), value2);
        entity2.setStringProperty(null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class, Joiners.equal(TestdataLavishEntity::getValue, Function.identity()), Joiners.filtering((entity, value) -> value.getCode().contains("1"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1));
        scoreDirector.beforeEntityRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterEntityRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, value1));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_unknownClass() {
        this.assumeDrools();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(Integer.class, new TriJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifExists_0Joiner0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).ifExists(TestdataLavishEntityGroup.class, new TriJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(valueGroup, solution.getFirstValueGroup()));
        TestdataLavishEntityGroup entityGroup = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_0Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.filtering((entityA, entityB, group) -> Objects.equals(group, entityA.getEntityGroup()) && Objects.equals(group, entityB.getEntityGroup()))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2));
        TestdataLavishEntityGroup toRemove = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getEntityGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExists_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2), BiConstraintStreamTest.assertMatch(entity1, entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2));
    }

    @Override
    @TestTemplate
    public void ifExists_1Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, group) -> entityA.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifExistsDoesNotIncludeNullVars() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    public void ifExistsIncludesNullVarsWithFrom() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.fromUniquePair(TestdataLavishEntity.class).ifExists(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1));
        scoreDirector.beforeProblemFactRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterProblemFactRemoved((Object)entity2);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
    }

    @Override
    @TestTemplate
    public void ifNotExists_unknownClass() {
        this.assumeDrools();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifNotExists(Integer.class, new TriJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE))).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining(Integer.class.getCanonicalName()).hasMessageContaining("assignable from");
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Joiner0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        TestdataLavishValueGroup valueGroup = new TestdataLavishValueGroup("MyValueGroup");
        solution.getValueGroupList().add(valueGroup);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishValueGroup.class).ifNotExists(TestdataLavishEntityGroup.class, new TriJoiner[0]).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        TestdataLavishEntityGroup entityGroup = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(valueGroup, solution.getFirstValueGroup()));
    }

    @Override
    @TestTemplate
    public void ifNotExists_0Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.filtering((entityA, entityB, group) -> Objects.equals(group, entityA.getEntityGroup()) && Objects.equals(group, entityB.getEntityGroup()))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(entity1, entity2));
        TestdataLavishEntityGroup toRemove = solution.getFirstEntityGroup();
        scoreDirector.beforeProblemFactRemoved((Object)toRemove);
        solution.getEntityGroupList().remove(toRemove);
        scoreDirector.afterProblemFactRemoved((Object)toRemove);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2), BiConstraintStreamTest.assertMatch(entity1, entity2));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join0Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, entity2));
    }

    @Override
    @TestTemplate
    public void ifNotExists_1Join1Filter() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntityGroup.class, Joiners.equal((entityA, entityB) -> entityA.getEntityGroup(), Function.identity()), Joiners.filtering((entityA, entityB, group) -> entityA.getCode().contains("MyEntity") || group.getCode().contains("MyEntity"))).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2));
        scoreDirector.beforeProblemFactRemoved((Object)entityGroup);
        solution.getEntityGroupList().remove(entityGroup);
        scoreDirector.afterProblemFactRemoved((Object)entityGroup);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1), BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity2), BiConstraintStreamTest.assertMatch(entity1, entity2));
    }

    @Override
    @TestTemplate
    public void ifNotExistsDoesNotIncludeNullVars() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1));
        scoreDirector.beforeProblemFactRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterProblemFactRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1));
    }

    @Override
    @TestTemplate
    @Deprecated(forRemoval=true)
    public void ifNotExistsIncludesNullVarsWithFrom() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)1);
        TestdataLavishEntityGroup entityGroup = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", solution.getFirstEntityGroup(), null);
        solution.getEntityList().add(entity2);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.fromUniquePair(TestdataLavishEntity.class).ifNotExists(TestdataLavishEntity.class, Joiners.filtering((a, b, c) -> a != c && b != c)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, new AbstractConstraintStreamTest.AssertableMatch[0]);
        scoreDirector.beforeProblemFactRemoved((Object)entity2);
        solution.getEntityList().remove(entity2);
        scoreDirector.afterProblemFactRemoved((Object)entity2);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(solution.getFirstEntity(), entity1));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)1, (int)7);
        TestdataLavishEntityGroup entityGroup1 = new TestdataLavishEntityGroup("MyEntityGroup");
        solution.getEntityGroupList().add(entityGroup1);
        TestdataLavishEntity entity1 = new TestdataLavishEntity("MyEntity 1", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity1);
        TestdataLavishEntity entity2 = new TestdataLavishEntity("MyEntity 2", entityGroup1, solution.getFirstValue());
        solution.getEntityList().add(entity2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("MyEntity 3", solution.getFirstEntityGroup(), solution.getFirstValue());
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getEntityGroup)).groupBy((entityA, entityB) -> entityA.getEntityGroup()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup()), BiConstraintStreamTest.assertMatchWithScore(-1, entityGroup1));
        Stream.of(entity1, entity2).forEach(entity -> {
            scoreDirector.beforeEntityRemoved(entity);
            solution.getEntityList().remove(entity);
            scoreDirector.afterEntityRemoved(entity);
        });
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, solution.getFirstEntityGroup()));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping1Collector() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)7);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((entityA, entityB) -> entityA.toString(), ConstraintCollectors.countBi()).filter((entity, count) -> count > 4).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", solution.getFirstEntity().toString(), 6), BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", ((TestdataLavishEntity)solution.getEntityList().get(1)).toString(), 5));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", solution.getFirstEntity().toString(), 5));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((entityA, entityB) -> entityA.toString(), ConstraintCollectors.countBi(), ConstraintCollectors.toSet((entityA, entityB) -> entityA)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), 2, Collections.singleton(entity1)), BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), 1, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_1Mapping3Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((entityA, entityB) -> entityA.toString(), ConstraintCollectors.min((entityA, entityB) -> entityA.getLongProperty()), ConstraintCollectors.max((entityA, entityB) -> entityA.getLongProperty()), ConstraintCollectors.toSet((entityA, entityB) -> entityA)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(Long.MAX_VALUE));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(Long.MIN_VALUE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity1.toString(), Long.MAX_VALUE, Long.MAX_VALUE, Collections.singleton(entity1)), BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, "testConstraintName", entity2.toString(), Long.MIN_VALUE, Long.MIN_VALUE, Collections.singleton(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, count -> count));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-3, 3));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countBi(), ConstraintCollectors.countDistinct((e, e2) -> e)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 3, 2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping3Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countBi(), ConstraintCollectors.min((e, e2) -> e.getLongProperty()), ConstraintCollectors.max((e, e2) -> e.getLongProperty())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L));
    }

    @Override
    @TestTemplate
    public void groupBy_0Mapping4Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy(ConstraintCollectors.countBi(), ConstraintCollectors.min((e, e2) -> e.getLongProperty()), ConstraintCollectors.max((e, e2) -> e.getLongProperty()), ConstraintCollectors.toSet((e, e2) -> e)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        entity1.setLongProperty(Long.valueOf(0L));
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setLongProperty(Long.valueOf(1L));
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        entity3.setLongProperty(Long.valueOf(2L));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 3, 0L, 1L, BiConstraintStreamTest.asSet(entity1, entity2)));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, 1, 1L, 1L, BiConstraintStreamTest.asSet(entity2)));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)5, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group1, group2), BiConstraintStreamTest.assertMatchWithScore(-1, group1, group3), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)4);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (entityGroup1, entityGroup2, count) -> count));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group1, group1, 1), BiConstraintStreamTest.assertMatchWithScore(-3, group1, group2, 3), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group1, 1), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group2, 1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group2, group2, 1), BiConstraintStreamTest.assertMatchWithScore(-1, group1, group2, 1), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_2Mapping2Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)4);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup(), ConstraintCollectors.countBi(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE, (entityGroup1, entityGroup2, count, sameCount) -> count + sameCount));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-2, group1, group1, 1, 1), BiConstraintStreamTest.assertMatchWithScore(-6, group1, group2, 3, 3), BiConstraintStreamTest.assertMatchWithScore(-2, group2, group1, 1, 1), BiConstraintStreamTest.assertMatchWithScore(-2, group2, group2, 1, 1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-2, group2, group2, 1, 1), BiConstraintStreamTest.assertMatchWithScore(-2, group1, group2, 1, 1), BiConstraintStreamTest.assertMatchWithScore(-2, group2, group1, 1, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup(), (a, b) -> a.getValue()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        TestdataLavishValue value1 = (TestdataLavishValue)solution.getValueList().get(0);
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group1, group2, value1), BiConstraintStreamTest.assertMatchWithScore(-1, group1, group3, value1), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2));
    }

    @Override
    @TestTemplate
    public void groupBy_3Mapping1Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup(), (a, b) -> a.getValue(), ConstraintCollectors.countBi()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        TestdataLavishValue value1 = (TestdataLavishValue)solution.getValueList().get(0);
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group1, group2, value1, 1), BiConstraintStreamTest.assertMatchWithScore(-1, group1, group3, value1, 1), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2, 1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2, 1));
    }

    @Override
    @TestTemplate
    public void groupBy_4Mapping0Collector() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).groupBy((a, b) -> a.getEntityGroup(), (a, b) -> b.getEntityGroup(), (a, b) -> a.getValue(), (a, b) -> b.getValue()).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(0);
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        TestdataLavishValue value1 = (TestdataLavishValue)solution.getValueList().get(0);
        TestdataLavishValue value2 = (TestdataLavishValue)solution.getValueList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group1, group2, value1, value2), BiConstraintStreamTest.assertMatchWithScore(-1, group1, group3, value1, value1), BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2, value1));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatchWithScore(-1, group2, group3, value2, value1));
    }

    @Override
    @TestTemplate
    public void distinct() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)2, (int)2, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntity entity3 = (TestdataLavishEntity)solution.getEntityList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, entity2), BiConstraintStreamTest.assertMatch(entity1, entity3), BiConstraintStreamTest.assertMatch(entity2, entity3));
    }

    @Override
    @TestTemplate
    public void mapWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).map((a, b) -> BiConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)));
    }

    @Override
    @TestTemplate
    public void mapWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).map((a, b) -> BiConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group3)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group2, group3)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group2, group3)));
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).map((a, b) -> BiConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)));
    }

    @Override
    @TestTemplate
    public void mapAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)3, (int)3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).map((a, b) -> BiConstraintStreamTest.asSet(a.getEntityGroup(), b.getEntityGroup())).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        TestdataLavishEntityGroup group3 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(2);
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group2)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group1, group3)), BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group2, group3)));
        TestdataLavishEntity entity = solution.getFirstEntity();
        scoreDirector.beforeEntityRemoved((Object)entity);
        solution.getEntityList().remove(entity);
        scoreDirector.afterEntityRemoved((Object)entity);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(BiConstraintStreamTest.asSet(group2, group3)));
    }

    @Override
    @TestTemplate
    public void flattenLastWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).flattenLast(b -> Arrays.asList(b.getEntityGroup(), group1, group2)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, group1), BiConstraintStreamTest.assertMatch(entity1, group1), BiConstraintStreamTest.assertMatch(entity1, group2), BiConstraintStreamTest.assertMatch(entity2, group2), BiConstraintStreamTest.assertMatch(entity2, group1), BiConstraintStreamTest.assertMatch(entity2, group2), BiConstraintStreamTest.assertMatch(entity1, group1), BiConstraintStreamTest.assertMatch(entity1, group1), BiConstraintStreamTest.assertMatch(entity1, group2));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group2), BiConstraintStreamTest.assertMatch(entity2, group1), BiConstraintStreamTest.assertMatch(entity2, group2));
    }

    @Override
    @TestTemplate
    public void flattenLastWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).flattenLast(b -> Collections.singleton(b.getEntityGroup())).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group1), BiConstraintStreamTest.assertMatch(entity1, group2), BiConstraintStreamTest.assertMatch(entity1, group1));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group1));
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).flattenLast(b -> Arrays.asList(b.getEntityGroup(), group1, group2)).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, group1), BiConstraintStreamTest.assertMatch(entity1, group2), BiConstraintStreamTest.assertMatch(entity2, group2), BiConstraintStreamTest.assertMatch(entity2, group1));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group1), BiConstraintStreamTest.assertMatch(entity2, group2));
    }

    @Override
    @TestTemplate
    public void flattenLastAndDistinctWithoutDuplicates() {
        this.assumeDrools();
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)2, (int)3);
        TestdataLavishEntity entity1 = solution.getFirstEntity();
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        TestdataLavishEntityGroup group1 = solution.getFirstEntityGroup();
        TestdataLavishEntityGroup group2 = (TestdataLavishEntityGroup)solution.getEntityGroupList().get(1);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEachUniquePair(TestdataLavishEntity.class).flattenLast(b -> Collections.singleton(b.getEntityGroup())).distinct().penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group1), BiConstraintStreamTest.assertMatch(entity1, group2), BiConstraintStreamTest.assertMatch(entity1, group1));
        scoreDirector.beforeEntityRemoved((Object)entity1);
        solution.getEntityList().remove(entity1);
        scoreDirector.afterEntityRemoved((Object)entity1);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity2, group1));
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_Int() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_Long() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void penalize_BigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void penalize_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        String constraintName = "myConstraint";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class).penalize(constraintName, (Score)SimpleScore.ONE, (entity, value) -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_Int() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_Long() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    @TestTemplate
    public void reward_BigDecimal() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    @TestTemplate
    public void reward_negative() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)1, (int)1, (int)1);
        String constraintName = "myConstraint";
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishValue.class).reward(constraintName, (Score)SimpleScore.ONE, (entity, value) -> -1));
        scoreDirector.setWorkingSolution((Object)solution);
        Assertions.assertThatThrownBy(() -> scoreDirector.calculateScore()).hasMessageContaining(constraintName);
    }

    @TestTemplate
    public void joinerEqualsAndSameness() {
        TestdataLavishSolution solution = TestdataLavishSolution.generateSolution((int)1, (int)2, (int)1, (int)2);
        String decimal = "0.01";
        BigDecimal bigDecimal1 = new BigDecimal(decimal);
        BigDecimal bigDecimal2 = new BigDecimal(decimal);
        TestdataLavishEntity entity1 = (TestdataLavishEntity)solution.getEntityList().get(0);
        entity1.setBigDecimalProperty(bigDecimal1);
        TestdataLavishEntity entity2 = (TestdataLavishEntity)solution.getEntityList().get(1);
        entity2.setBigDecimalProperty(bigDecimal2);
        TestdataLavishEntity entity3 = new TestdataLavishEntity("My Entity 0", solution.getFirstEntityGroup(), entity1.getValue());
        entity3.setBigDecimalProperty(bigDecimal1);
        solution.getEntityList().add(entity3);
        InnerScoreDirector<TestdataLavishSolution, SimpleScore> scoreDirector = this.buildScoreDirector(factory -> factory.forEach(TestdataLavishEntity.class).join(TestdataLavishEntity.class, Joiners.equal(TestdataLavishEntity::getBigDecimalProperty)).penalize("testConstraintName", (Score)SimpleScore.ONE));
        scoreDirector.setWorkingSolution((Object)solution);
        this.assertScore(scoreDirector, BiConstraintStreamTest.assertMatch(entity1, entity1), BiConstraintStreamTest.assertMatch(entity2, entity2), BiConstraintStreamTest.assertMatch(entity3, entity3), BiConstraintStreamTest.assertMatch(entity1, entity2), BiConstraintStreamTest.assertMatch(entity1, entity3), BiConstraintStreamTest.assertMatch(entity2, entity1), BiConstraintStreamTest.assertMatch(entity2, entity3), BiConstraintStreamTest.assertMatch(entity3, entity1), BiConstraintStreamTest.assertMatch(entity3, entity2));
    }
}

