/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.tri;

import java.util.ArrayList;
import java.util.List;
import org.optaplanner.constraint.streams.tri.DefaultTriJoiner;
import org.optaplanner.constraint.streams.tri.FilteringTriJoiner;
import org.optaplanner.core.api.function.TriPredicate;
import org.optaplanner.core.api.score.stream.tri.TriJoiner;

public class TriJoinerComber<A, B, C> {
    private DefaultTriJoiner<A, B, C> mergedJoiner;
    private TriPredicate<A, B, C> mergedFiltering;

    public static <A, B, C> TriJoinerComber<A, B, C> comb(TriJoiner<A, B, C>[] joiners) {
        ArrayList defaultJoinerList = new ArrayList(joiners.length);
        ArrayList<TriPredicate<A, B, C>> filteringList = new ArrayList<TriPredicate<A, B, C>>(joiners.length);
        int indexOfFirstFilter = -1;
        for (int i = 0; i < joiners.length; ++i) {
            TriJoiner<A, B, C> joiner = joiners[i];
            if (joiner instanceof FilteringTriJoiner) {
                indexOfFirstFilter = i;
                filteringList.add(((FilteringTriJoiner)joiner).getFilter());
                continue;
            }
            if (joiner instanceof DefaultTriJoiner) {
                if (indexOfFirstFilter >= 0) {
                    throw new IllegalStateException("Indexing joiner (" + joiner + ") must not follow a filtering joiner (" + joiners[indexOfFirstFilter] + ").\nMaybe reorder the joiners such that filtering() joiners are later in the parameter list.");
                }
                defaultJoinerList.add((DefaultTriJoiner)joiner);
                continue;
            }
            throw new IllegalArgumentException("The joiner class (" + joiner.getClass() + ") is not supported.");
        }
        DefaultTriJoiner mergedJoiner = DefaultTriJoiner.merge(defaultJoinerList);
        TriPredicate<A, B, C> mergedFiltering = TriJoinerComber.mergeFiltering(filteringList);
        return new TriJoinerComber(mergedJoiner, mergedFiltering);
    }

    private static <A, B, C> TriPredicate<A, B, C> mergeFiltering(List<TriPredicate<A, B, C>> filteringList) {
        if (filteringList.size() == 0) {
            return null;
        }
        if (filteringList.size() == 1) {
            return filteringList.get(0);
        }
        if (filteringList.size() == 2) {
            return filteringList.get(0).and(filteringList.get(1));
        }
        TriPredicate[] predicates = (TriPredicate[])filteringList.toArray(TriPredicate[]::new);
        return (a, b, c) -> {
            for (TriPredicate predicate : predicates) {
                if (predicate.test(a, b, c)) continue;
                return false;
            }
            return true;
        };
    }

    public TriJoinerComber(DefaultTriJoiner<A, B, C> mergedJoiner, TriPredicate<A, B, C> mergedFiltering) {
        this.mergedJoiner = mergedJoiner;
        this.mergedFiltering = mergedFiltering;
    }

    public DefaultTriJoiner<A, B, C> getMergedJoiner() {
        return this.mergedJoiner;
    }

    public TriPredicate<A, B, C> getMergedFiltering() {
        return this.mergedFiltering;
    }
}

