/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams;

import java.util.Collections;
import org.assertj.core.api.SoftAssertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.optaplanner.core.api.score.ScoreExplanation;
import org.optaplanner.core.api.score.ScoreManager;
import org.optaplanner.core.api.score.ScoreManagerTest;
import org.optaplanner.core.api.score.buildin.simple.SimpleScore;
import org.optaplanner.core.api.score.stream.ConstraintStreamImplType;
import org.optaplanner.core.api.solver.SolverFactory;
import org.optaplanner.core.config.score.director.ScoreDirectorFactoryConfig;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.impl.testdata.domain.TestdataConstraintProvider;
import org.optaplanner.core.impl.testdata.domain.TestdataEntity;
import org.optaplanner.core.impl.testdata.domain.TestdataSolution;

class ScoreManagerTest {
    ScoreManagerTest() {
    }

    @ParameterizedTest
    @EnumSource(value=ConstraintStreamImplType.class)
    void indictmentsPresentOnFreshExplanation(ConstraintStreamImplType constraintStreamImplType) {
        ScoreDirectorFactoryConfig scoreDirectorFactoryConfig = new ScoreDirectorFactoryConfig();
        scoreDirectorFactoryConfig.setConstraintProviderClass(TestdataConstraintProvider.class);
        scoreDirectorFactoryConfig.setConstraintStreamImplType(constraintStreamImplType);
        SolverConfig solverConfig = new SolverConfig();
        solverConfig.setSolutionClass(TestdataSolution.class);
        solverConfig.setEntityClassList(Collections.singletonList(TestdataEntity.class));
        solverConfig.setScoreDirectorFactoryConfig(scoreDirectorFactoryConfig);
        SolverFactory solverFactory = SolverFactory.create((SolverConfig)solverConfig);
        ScoreManager scoreManager = ScoreManagerTest.ScoreManagerSource.FROM_SOLVER_FACTORY.createScoreManager(solverFactory);
        int entityCount = 3;
        TestdataSolution solution = TestdataSolution.generateSolution((int)2, (int)entityCount);
        ScoreExplanation scoreExplanation = scoreManager.explainScore((Object)solution);
        SoftAssertions.assertSoftly(softly -> {
            softly.assertThat((Comparable)((SimpleScore)scoreExplanation.getScore())).isEqualTo((Object)SimpleScore.of((int)(-entityCount)));
            softly.assertThat(scoreExplanation.getConstraintMatchTotalMap()).isNotEmpty();
            softly.assertThat(scoreExplanation.getIndictmentMap()).isNotEmpty();
        });
    }
}

