/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardSoftLongScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoftlong.HardSoftLongScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardSoftLongScoreSolution;

class HardSoftLongScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardSoftLongScoreSolution, HardSoftLongScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    HardSoftLongScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        HardSoftLongScoreInliner scoreInliner = new HardSoftLongScoreInliner(true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.ZERO);
    }

    @Test
    void impactHard() {
        HardSoftLongScoreInliner scoreInliner = new HardSoftLongScoreInliner(true);
        HardSoftLongScore constraintWeight = HardSoftLongScore.ofHard((long)90L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)90L, (long)0L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)270L, (long)0L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)90L, (long)0L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)0L));
    }

    @Test
    void impactSoft() {
        HardSoftLongScoreInliner scoreInliner = new HardSoftLongScoreInliner(true);
        HardSoftLongScore constraintWeight = HardSoftLongScore.ofSoft((long)90L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)90L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)270L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)90L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)0L));
    }

    @Test
    void impactAll() {
        HardSoftLongScoreInliner scoreInliner = new HardSoftLongScoreInliner(true);
        HardSoftLongScore constraintWeight = HardSoftLongScore.of((long)10L, (long)100L);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)100L, (long)1000L));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)300L, (long)3000L));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)100L, (long)1000L));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftLongScore.of((long)0L, (long)0L));
    }

    @Override
    protected SolutionDescriptor<TestdataHardSoftLongScoreSolution> buildSolutionDescriptor() {
        return TestdataHardSoftLongScoreSolution.buildSolutionDescriptor();
    }
}

