/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.common.inliner;

import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInlinerTest;
import org.optaplanner.constraint.streams.common.inliner.HardSoftScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.JustificationsSupplier;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.testdata.domain.score.TestdataHardSoftScoreSolution;

class HardSoftScoreInlinerTest
extends AbstractScoreInlinerTest<TestdataHardSoftScoreSolution, HardSoftScore> {
    private static final JustificationsSupplier EMPTY_JUSTIFICATIONS_SUPPLIER = Collections::emptyList;

    HardSoftScoreInlinerTest() {
    }

    @Test
    void defaultScore() {
        HardSoftScoreInliner scoreInliner = new HardSoftScoreInliner(true);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.ZERO);
    }

    @Test
    void impactHard() {
        HardSoftScoreInliner scoreInliner = new HardSoftScoreInliner(true);
        HardSoftScore constraintWeight = HardSoftScore.ofHard((int)90);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)90, (int)0));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)270, (int)0));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)90, (int)0));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)0));
    }

    @Test
    void impactSoft() {
        HardSoftScoreInliner scoreInliner = new HardSoftScoreInliner(true);
        HardSoftScore constraintWeight = HardSoftScore.ofSoft((int)90);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(1, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)90));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(2, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)270));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)90));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)0));
    }

    @Test
    void impactAll() {
        HardSoftScoreInliner scoreInliner = new HardSoftScoreInliner(true);
        HardSoftScore constraintWeight = HardSoftScore.of((int)10, (int)100);
        WeightedScoreImpacter hardImpacter = scoreInliner.buildWeightedScoreImpacter(this.buildConstraint(constraintWeight), constraintWeight);
        UndoScoreImpacter undo1 = hardImpacter.impactScore(10, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)100, (int)1000));
        UndoScoreImpacter undo2 = hardImpacter.impactScore(20, EMPTY_JUSTIFICATIONS_SUPPLIER);
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)300, (int)3000));
        undo2.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)100, (int)1000));
        undo1.run();
        Assertions.assertThat((Comparable)scoreInliner.extractScore(0)).isEqualTo((Object)HardSoftScore.of((int)0, (int)0));
    }

    @Override
    protected SolutionDescriptor<TestdataHardSoftScoreSolution> buildSolutionDescriptor() {
        return TestdataHardSoftScoreSolution.buildSolutionDescriptor();
    }
}

