/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.bi;

import java.util.ArrayDeque;
import java.util.LinkedHashSet;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;
import org.optaplanner.core.api.function.TriPredicate;

public final class IfExistsBiWithUniNode<A, B, C>
extends AbstractNode {
    private final boolean shouldExist;
    private final BiFunction<A, B, IndexProperties> mappingAB;
    private final Function<C, IndexProperties> mappingC;
    private final int inputStoreIndexAB;
    private final int inputStoreIndexC;
    private final Consumer<BiTuple<A, B>> nextNodesInsert;
    private final Consumer<BiTuple<A, B>> nextNodesRetract;
    private final Indexer<BiTuple<A, B>, Counter<A, B>> indexerAB;
    private final Indexer<UniTuple<C>, Set<Counter<A, B>>> indexerC;
    private final TriPredicate<A, B, C> filtering;
    private final Queue<Counter<A, B>> dirtyCounterQueue;

    public IfExistsBiWithUniNode(boolean shouldExist, BiFunction<A, B, IndexProperties> mappingAB, Function<C, IndexProperties> mappingC, int inputStoreIndexAB, int inputStoreIndexC, Consumer<BiTuple<A, B>> nextNodesInsert, Consumer<BiTuple<A, B>> nextNodesRetract, Indexer<BiTuple<A, B>, Counter<A, B>> indexerAB, Indexer<UniTuple<C>, Set<Counter<A, B>>> indexerC, TriPredicate<A, B, C> filtering) {
        this.shouldExist = shouldExist;
        this.mappingAB = mappingAB;
        this.mappingC = mappingC;
        this.inputStoreIndexAB = inputStoreIndexAB;
        this.inputStoreIndexC = inputStoreIndexC;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.indexerAB = indexerAB;
        this.indexerC = indexerC;
        this.filtering = filtering;
        this.dirtyCounterQueue = new ArrayDeque<Counter<A, B>>(1000);
    }

    public void insertAB(BiTuple<A, B> tupleAB) {
        if (tupleAB.store[this.inputStoreIndexAB] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleAB + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingAB.apply(tupleAB.factA, tupleAB.factB);
        tupleAB.store[this.inputStoreIndexAB] = indexProperties;
        Counter<A, B> counter = new Counter<A, B>(tupleAB);
        this.indexerAB.put(indexProperties, tupleAB, counter);
        counter.countC = 0;
        this.indexerC.visit(indexProperties, (tupleC, counterSetC) -> {
            if (this.filtering == null || this.filtering.test(tupleAB.factA, tupleAB.factB, tupleC.factA)) {
                ++counter.countC;
                counterSetC.add(counter);
            }
        });
        if (this.shouldExist ? counter.countC > 0 : counter.countC == 0) {
            counter.state = BavetTupleState.CREATING;
            this.dirtyCounterQueue.add(counter);
        }
    }

    public void retractAB(BiTuple<A, B> tupleAB) {
        IndexProperties indexProperties = (IndexProperties)tupleAB.store[this.inputStoreIndexAB];
        if (indexProperties == null) {
            return;
        }
        tupleAB.store[this.inputStoreIndexAB] = null;
        Counter<A, B> counter = this.indexerAB.remove(indexProperties, tupleAB);
        this.indexerC.visit(indexProperties, (tupleC, counterSetC) -> {
            boolean changed = counterSetC.remove(counter);
            if (!changed && this.filtering == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + tupleAB + ") with indexProperties (" + indexProperties + ") has a counter on the AB side that doesn't exist on the C side.");
            }
        });
        if (this.shouldExist ? counter.countC > 0 : counter.countC == 0) {
            this.retractCounter(counter);
        }
    }

    public void insertC(UniTuple<C> tupleC) {
        if (tupleC.store[this.inputStoreIndexC] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tupleC + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingC.apply(tupleC.factA);
        tupleC.store[this.inputStoreIndexC] = indexProperties;
        LinkedHashSet counterSetC = new LinkedHashSet();
        this.indexerC.put(indexProperties, tupleC, counterSetC);
        this.indexerAB.visit(indexProperties, (tupleAB, counter) -> {
            if (this.filtering == null || this.filtering.test(tupleAB.factA, tupleAB.factB, tupleC.factA)) {
                if (counter.countC == 0) {
                    if (this.shouldExist) {
                        this.insertCounter((Counter<A, B>)counter);
                    } else {
                        this.retractCounter((Counter<A, B>)counter);
                    }
                }
                ++counter.countC;
                counterSetC.add(counter);
            }
        });
    }

    public void retractC(UniTuple<C> tupleC) {
        IndexProperties indexProperties = (IndexProperties)tupleC.store[this.inputStoreIndexC];
        if (indexProperties == null) {
            return;
        }
        tupleC.store[this.inputStoreIndexC] = null;
        Set<Counter<A, B>> counterSetC = this.indexerC.remove(indexProperties, tupleC);
        for (Counter<A, B> counter : counterSetC) {
            --counter.countC;
            if (counter.countC != 0) continue;
            if (this.shouldExist) {
                this.retractCounter(counter);
                continue;
            }
            this.insertCounter(counter);
        }
    }

    private void insertCounter(Counter<A, B> counter) {
        switch (counter.state) {
            case DYING: {
                counter.state = BavetTupleState.UPDATING;
                break;
            }
            case DEAD: {
                counter.state = BavetTupleState.CREATING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            case ABORTING: {
                counter.state = BavetTupleState.CREATING;
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: the counter (" + counter + ") has an impossible insert state (" + counter.state + ").");
            }
        }
    }

    private void retractCounter(Counter<A, B> counter) {
        switch (counter.state) {
            case CREATING: {
                counter.state = BavetTupleState.ABORTING;
                break;
            }
            case UPDATING: {
                counter.state = BavetTupleState.DYING;
                break;
            }
            case OK: {
                counter.state = BavetTupleState.DYING;
                this.dirtyCounterQueue.add(counter);
                break;
            }
            default: {
                throw new IllegalStateException("Impossible state: The counter (" + counter + ") has an impossible retract state (" + counter.state + ").");
            }
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyCounterQueue.forEach(counter -> {
            switch (counter.state) {
                case CREATING: {
                    this.nextNodesInsert.accept(counter.tuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case UPDATING: {
                    this.nextNodesRetract.accept(counter.tuple);
                    this.nextNodesInsert.accept(counter.tuple);
                    counter.state = BavetTupleState.OK;
                    break;
                }
                case DYING: {
                    this.nextNodesRetract.accept(counter.tuple);
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                case ABORTING: {
                    counter.state = BavetTupleState.DEAD;
                    break;
                }
                default: {
                    throw new IllegalStateException("Impossible state: The dirty counter (" + counter + ") has an non-dirty state (" + counter.state + ").");
                }
            }
        });
        this.dirtyCounterQueue.clear();
    }

    public String toString() {
        return "IfExistsBiWithUniNode";
    }

    protected static class Counter<A, B> {
        public BiTuple<A, B> tuple;
        public BavetTupleState state = BavetTupleState.DEAD;
        public int countC = 0;

        public Counter(BiTuple<A, B> tuple) {
            this.tuple = tuple;
        }

        public String toString() {
            return "Counter(" + this.tuple + ")";
        }
    }
}

