/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.drools;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.drools.ancompiler.KieBaseUpdaterANC;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.model.DSL;
import org.drools.model.Global;
import org.drools.model.Model;
import org.drools.model.impl.ModelImpl;
import org.drools.modelcompiler.builder.KieBaseBuilder;
import org.kie.api.KieBase;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.KieServices;
import org.kie.api.conf.KieBaseMutabilityOption;
import org.kie.api.conf.KieBaseOption;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.DirectFiringOption;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.rule.AgendaFilter;
import org.kie.api.runtime.rule.Match;
import org.kie.internal.builder.conf.PropertySpecificOption;
import org.kie.internal.event.rule.RuleEventListener;
import org.kie.internal.event.rule.RuleEventManager;
import org.optaplanner.constraint.streams.common.AbstractConstraintStreamScoreDirectorFactory;
import org.optaplanner.constraint.streams.common.inliner.AbstractScoreInliner;
import org.optaplanner.constraint.streams.common.inliner.WeightedScoreImpacter;
import org.optaplanner.constraint.streams.drools.DroolsConstraint;
import org.optaplanner.constraint.streams.drools.DroolsConstraintFactory;
import org.optaplanner.constraint.streams.drools.DroolsConstraintStreamScoreDirector;
import org.optaplanner.constraint.streams.drools.KieBaseDescriptor;
import org.optaplanner.constraint.streams.drools.OptaPlannerRuleEventListener;
import org.optaplanner.constraint.streams.drools.SessionDescriptor;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.score.definition.ScoreDefinition;

public final class DroolsConstraintStreamScoreDirectorFactory<Solution_, Score_ extends Score<Score_>>
extends AbstractConstraintStreamScoreDirectorFactory<Solution_, Score_> {
    private final KieBaseDescriptor<Solution_> kieBaseDescriptor;
    private final boolean droolsAlphaNetworkCompilationEnabled;

    public DroolsConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, boolean droolsAlphaNetworkCompilationEnabled) {
        this(solutionDescriptor, DroolsConstraintStreamScoreDirectorFactory.buildKieBase(solutionDescriptor, constraintProvider, droolsAlphaNetworkCompilationEnabled), droolsAlphaNetworkCompilationEnabled);
    }

    public DroolsConstraintStreamScoreDirectorFactory(SolutionDescriptor<Solution_> solutionDescriptor, KieBaseDescriptor<Solution_> kieBaseDescriptor, boolean droolsAlphaNetworkCompilationEnabled) {
        super(solutionDescriptor);
        this.kieBaseDescriptor = Objects.requireNonNull(kieBaseDescriptor);
        this.droolsAlphaNetworkCompilationEnabled = droolsAlphaNetworkCompilationEnabled;
    }

    public DroolsConstraintStreamScoreDirector<Solution_, Score_> buildScoreDirector(boolean lookUpEnabled, boolean constraintMatchEnabledPreference) {
        return new DroolsConstraintStreamScoreDirector(this, lookUpEnabled, constraintMatchEnabledPreference);
    }

    public static <Solution_> KieBaseDescriptor<Solution_> buildKieBase(SolutionDescriptor<Solution_> solutionDescriptor, ConstraintProvider constraintProvider, boolean droolsAlphaNetworkCompilationEnabled) {
        List constraints = new DroolsConstraintFactory<Solution_>(solutionDescriptor).buildConstraints(constraintProvider);
        AtomicInteger idCounter = new AtomicInteger(0);
        Map constraintToGlobalMap = constraints.stream().collect(Collectors.toMap(Function.identity(), c -> DSL.globalOf(WeightedScoreImpacter.class, (String)c.getConstraintPackage(), (String)("scoreImpacter" + idCounter.getAndIncrement()))));
        ModelImpl model = constraints.stream().map(constraint -> constraint.buildRule((Global<WeightedScoreImpacter>)((Global)constraintToGlobalMap.get(constraint)))).reduce(new ModelImpl(), ModelImpl::addRule, (m, key) -> m);
        constraintToGlobalMap.forEach((constraint, global) -> model.addGlobal(global));
        KieBase kieBase = DroolsConstraintStreamScoreDirectorFactory.buildKieBaseFromModel((Model)model, droolsAlphaNetworkCompilationEnabled);
        return new KieBaseDescriptor(constraintToGlobalMap, kieBase);
    }

    private static KieBase buildKieBaseFromModel(Model model, boolean droolsAlphaNetworkCompilationEnabled) {
        KieBaseConfiguration kieBaseConfiguration = KieServices.get().newKieBaseConfiguration();
        kieBaseConfiguration.setOption((KieBaseOption)KieBaseMutabilityOption.DISABLED);
        kieBaseConfiguration.setProperty("drools.propertySpecific", PropertySpecificOption.DISABLED.name());
        InternalKnowledgeBase kieBase = KieBaseBuilder.createKieBaseFromModel((Model)model, (KieBaseConfiguration)kieBaseConfiguration);
        if (droolsAlphaNetworkCompilationEnabled) {
            KieBaseUpdaterANC.generateAndSetInMemoryANC((KieBase)kieBase);
        }
        return kieBase;
    }

    public SessionDescriptor<Score_> newConstraintStreamingSession(boolean constraintMatchEnabled, Solution_ workingSolution) {
        Map constraintToWeightMap = this.kieBaseDescriptor.getConstraintToGlobalMap().keySet().stream().collect(Collectors.toMap(Function.identity(), constraint -> constraint.extractConstraintWeight(workingSolution)));
        KieSession kieSession = DroolsConstraintStreamScoreDirectorFactory.buildKieSessionFromKieBase(this.kieBaseDescriptor.get());
        ((RuleEventManager)kieSession).addEventListener((RuleEventListener)new OptaPlannerRuleEventListener());
        ScoreDefinition scoreDefinition = this.solutionDescriptor.getScoreDefinition();
        Object scoreInliner = AbstractScoreInliner.buildScoreInliner(scoreDefinition, constraintMatchEnabled);
        HashSet<String> disabledConstraints = new HashSet<String>();
        for (Map.Entry entry : constraintToWeightMap.entrySet()) {
            DroolsConstraint constraint2 = (DroolsConstraint)entry.getKey();
            Score constraintWeight = entry.getValue();
            if (constraintWeight.isZero()) {
                disabledConstraints.add(constraint2.getConstraintId());
                continue;
            }
            String globalName = this.kieBaseDescriptor.getConstraintToGlobalMap().get(constraint2).getName();
            kieSession.setGlobal(globalName, (Object)((AbstractScoreInliner)scoreInliner).buildWeightedScoreImpacter(constraint2, (Score)constraintWeight));
        }
        ConstraintDisablingAgendaFilter agendaFilter = disabledConstraints.isEmpty() ? null : new ConstraintDisablingAgendaFilter(Set.copyOf(disabledConstraints));
        return new SessionDescriptor(kieSession, scoreInliner, agendaFilter);
    }

    private static KieSession buildKieSessionFromKieBase(KieBase kieBase) {
        KieSessionConfiguration config = KieServices.get().newKieSessionConfiguration();
        config.setOption((KieSessionOption)DirectFiringOption.YES);
        Environment environment = KieServices.get().newEnvironment();
        return kieBase.newKieSession(config, environment);
    }

    @Override
    public Constraint[] getConstraints() {
        return (Constraint[])this.kieBaseDescriptor.getConstraintToGlobalMap().keySet().toArray(Constraint[]::new);
    }

    public boolean isDroolsAlphaNetworkCompilationEnabled() {
        return this.droolsAlphaNetworkCompilationEnabled;
    }

    private static final class ConstraintDisablingAgendaFilter
    implements AgendaFilter {
        private final Set<String> disabledConstraintIdSet;
        private final Map<Rule, Boolean> ruleEnabledCache = new HashMap<Rule, Boolean>();

        public ConstraintDisablingAgendaFilter(Set<String> disabledConstraintIdSet) {
            this.disabledConstraintIdSet = Objects.requireNonNull(disabledConstraintIdSet);
        }

        public boolean accept(Match match) {
            Rule rule = match.getRule();
            return this.ruleEnabledCache.computeIfAbsent(rule, r -> {
                String constraintId = ConstraintMatchTotal.composeConstraintId((String)r.getPackageName(), (String)r.getName());
                return !this.disabledConstraintIdSet.contains(constraintId);
            });
        }
    }
}

