/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.common.GroupPart;
import org.optaplanner.constraint.streams.bavet.common.Tuple;

public abstract class AbstractGroupNode<InTuple_ extends Tuple, OutTuple_ extends Tuple, GroupKey_, ResultContainer_>
extends AbstractNode {
    private final int groupStoreIndex;
    private final Supplier<ResultContainer_> supplier;
    private final boolean runAccumulate;
    private final Consumer<OutTuple_> nextNodesInsert;
    private final Consumer<OutTuple_> nextNodesRetract;
    private final Map<GroupKey_, Group<OutTuple_, GroupKey_, ResultContainer_>> groupMap;
    private final Queue<Group<OutTuple_, GroupKey_, ResultContainer_>> dirtyGroupQueue;

    protected AbstractGroupNode(int groupStoreIndex, Supplier<ResultContainer_> supplier, Consumer<OutTuple_> nextNodesInsert, Consumer<OutTuple_> nextNodesRetract) {
        this.groupStoreIndex = groupStoreIndex;
        this.supplier = supplier;
        this.runAccumulate = supplier != null;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.groupMap = new HashMap<GroupKey_, Group<OutTuple_, GroupKey_, ResultContainer_>>(1000);
        this.dirtyGroupQueue = new ArrayDeque<Group<OutTuple_, GroupKey_, ResultContainer_>>(1000);
    }

    public void insert(InTuple_ tuple) {
        GroupPart<Group> groupPart;
        Object[] tupleStore = tuple.getStore();
        if (tupleStore[this.groupStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        GroupKey_ groupKey = this.createGroupKey(tuple);
        Group group = this.groupMap.computeIfAbsent(groupKey, k -> new Group(k, (this.runAccumulate ? (Object)this.supplier.get() : null)));
        ++group.parentCount;
        Runnable undoAccumulator = this.runAccumulate ? this.accumulate(group.resultContainer, tuple) : null;
        tupleStore[this.groupStoreIndex] = groupPart = new GroupPart<Group>(group, undoAccumulator);
        if (!group.dirty) {
            group.dirty = true;
            this.dirtyGroupQueue.add(group);
        }
    }

    protected abstract GroupKey_ createGroupKey(InTuple_ var1);

    protected abstract Runnable accumulate(ResultContainer_ var1, InTuple_ var2);

    protected abstract OutTuple_ createOutTuple(Group<OutTuple_, GroupKey_, ResultContainer_> var1);

    public void retract(InTuple_ tuple) {
        Object[] tupleStore = tuple.getStore();
        GroupPart groupPart = (GroupPart)tupleStore[this.groupStoreIndex];
        if (groupPart == null) {
            return;
        }
        tupleStore[this.groupStoreIndex] = null;
        Group group = (Group)groupPart.group;
        --group.parentCount;
        if (this.runAccumulate) {
            groupPart.undoAccumulator.run();
        }
        if (group.parentCount == 0) {
            Object groupKey = group.groupKey;
            Group<OutTuple_, GroupKey_, ResultContainer_> old = this.groupMap.remove(groupKey);
            if (old == null) {
                throw new IllegalStateException("Impossible state: the group for the groupKey (" + groupKey + ") doesn't exist in the groupMap.");
            }
            group.dying = true;
        }
        if (!group.dirty) {
            group.dirty = true;
            this.dirtyGroupQueue.add(group);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyGroupQueue.forEach(group -> {
            Object tuple;
            group.dirty = false;
            if (group.tuple != null) {
                tuple = group.tuple;
                BavetTupleState tupleState = tuple.getState();
                if (tupleState != BavetTupleState.OK) {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in the state (" + tupleState + ").");
                }
                tuple.setState(BavetTupleState.DYING);
                this.nextNodesRetract.accept(tuple);
                tuple.setState(BavetTupleState.DEAD);
            }
            if (!group.dying) {
                group.tuple = tuple = this.createOutTuple((Group<OutTuple_, GroupKey_, ResultContainer_>)group);
                this.nextNodesInsert.accept(tuple);
                tuple.setState(BavetTupleState.OK);
            }
        });
        this.dirtyGroupQueue.clear();
    }
}

