/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import org.optaplanner.constraint.streams.bavet.common.AbstractNode;
import org.optaplanner.constraint.streams.bavet.common.BavetTupleState;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.uni.UniTuple;

public abstract class AbstractJoinNode<LeftTuple_ extends Tuple, Right_, OutTuple_ extends Tuple>
extends AbstractNode {
    private final Function<Right_, IndexProperties> mappingRight;
    private final int inputStoreIndexLeft;
    private final int inputStoreIndexRight;
    private final Consumer<OutTuple_> nextNodesInsert;
    private final Consumer<OutTuple_> nextNodesRetract;
    private final Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft;
    private final Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight;
    private final Queue<OutTuple_> dirtyTupleQueue;

    protected AbstractJoinNode(Function<Right_, IndexProperties> mappingRight, int inputStoreIndexLeft, int inputStoreIndexRight, Consumer<OutTuple_> nextNodesInsert, Consumer<OutTuple_> nextNodesRetract, Indexer<LeftTuple_, Map<UniTuple<Right_>, OutTuple_>> indexerLeft, Indexer<UniTuple<Right_>, Map<LeftTuple_, OutTuple_>> indexerRight) {
        this.mappingRight = mappingRight;
        this.inputStoreIndexLeft = inputStoreIndexLeft;
        this.inputStoreIndexRight = inputStoreIndexRight;
        this.nextNodesInsert = nextNodesInsert;
        this.nextNodesRetract = nextNodesRetract;
        this.indexerLeft = indexerLeft;
        this.indexerRight = indexerRight;
        this.dirtyTupleQueue = new ArrayDeque<OutTuple_>(1000);
    }

    public final void insertLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        if (tupleStore[this.inputStoreIndexLeft] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + leftTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.createIndexProperties(leftTuple);
        tupleStore[this.inputStoreIndexLeft] = indexProperties;
        HashMap outTupleMapLeft = new HashMap();
        this.indexerLeft.put(indexProperties, leftTuple, outTupleMapLeft);
        this.indexerRight.visit(indexProperties, (rightTuple, emptyMap) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, (UniTuple<Right_>)rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put(rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    protected abstract IndexProperties createIndexProperties(LeftTuple_ var1);

    protected abstract OutTuple_ createOutTuple(LeftTuple_ var1, UniTuple<Right_> var2);

    public final void retractLeft(LeftTuple_ leftTuple) {
        Object[] tupleStore = leftTuple.getStore();
        IndexProperties indexProperties = (IndexProperties)tupleStore[this.inputStoreIndexLeft];
        if (indexProperties == null) {
            return;
        }
        tupleStore[this.inputStoreIndexLeft] = null;
        Map<UniTuple<Right_>, OutTuple_> outTupleMapLeft = this.indexerLeft.remove(indexProperties, leftTuple);
        for (Tuple outTuple : outTupleMapLeft.values()) {
            this.killTuple(outTuple);
        }
    }

    public final void insertRight(UniTuple<Right_> rightTuple) {
        if (rightTuple.store[this.inputStoreIndexRight] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + rightTuple + ") was already added in the tupleStore.");
        }
        IndexProperties indexProperties = this.mappingRight.apply(rightTuple.factA);
        rightTuple.store[this.inputStoreIndexRight] = indexProperties;
        this.indexerRight.put(indexProperties, rightTuple, Collections.emptyMap());
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            OutTuple_ outTuple = this.createOutTuple(leftTuple, rightTuple);
            outTuple.setState(BavetTupleState.CREATING);
            outTupleMapLeft.put(rightTuple, outTuple);
            this.dirtyTupleQueue.add(outTuple);
        });
    }

    public final void retractRight(UniTuple<Right_> rightTuple) {
        IndexProperties indexProperties = (IndexProperties)rightTuple.store[this.inputStoreIndexRight];
        if (indexProperties == null) {
            return;
        }
        rightTuple.store[this.inputStoreIndexRight] = null;
        this.indexerRight.remove(indexProperties, rightTuple);
        this.indexerLeft.visit(indexProperties, (leftTuple, outTupleMapLeft) -> {
            Tuple outTuple = (Tuple)outTupleMapLeft.remove(rightTuple);
            if (outTuple == null) {
                throw new IllegalStateException("Impossible state: the tuple (" + leftTuple + ") with indexProperties (" + indexProperties + ") has tuples on the right side that didn't exist on the left side.");
            }
            this.killTuple(outTuple);
        });
    }

    private void killTuple(OutTuple_ outTuple) {
        block6: {
            block5: {
                BavetTupleState state = outTuple.getState();
                if (!state.isDirty()) break block5;
                switch (state) {
                    case CREATING: {
                        outTuple.setState(BavetTupleState.ABORTING);
                        break block6;
                    }
                    case UPDATING: {
                        outTuple.setState(BavetTupleState.DYING);
                        break block6;
                    }
                    case DYING: {
                        break block6;
                    }
                    default: {
                        throw new IllegalStateException("Impossible state: The tuple (" + outTuple + ") has the dirty state (" + state + ").");
                    }
                }
            }
            outTuple.setState(BavetTupleState.DYING);
            this.dirtyTupleQueue.add(outTuple);
        }
    }

    @Override
    public void calculateScore() {
        this.dirtyTupleQueue.forEach(tuple -> {
            BavetTupleState state = tuple.getState();
            if (state == BavetTupleState.UPDATING || state == BavetTupleState.DYING) {
                this.nextNodesRetract.accept(tuple);
            }
            if (state == BavetTupleState.CREATING || state == BavetTupleState.UPDATING) {
                this.nextNodesInsert.accept(tuple);
            }
            switch (state) {
                case CREATING: 
                case UPDATING: {
                    tuple.setState(BavetTupleState.OK);
                    return;
                }
                case DYING: 
                case ABORTING: {
                    tuple.setState(BavetTupleState.DEAD);
                    return;
                }
                case DEAD: {
                    throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is already in the dead state (" + state + ").");
                }
            }
            throw new IllegalStateException("Impossible state: The tuple (" + tuple + ") in node (" + this + ") is in an unexpected state (" + state + ").");
        });
        this.dirtyTupleQueue.clear();
    }
}

