/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common;

import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.common.inliner.UndoScoreImpacter;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.constraint.ConstraintMatchTotal;

public abstract class AbstractScorer<Tuple_ extends Tuple> {
    private final String constraintId;
    private final Score<?> constraintWeight;
    private final int inputStoreIndex;

    protected AbstractScorer(String constraintPackage, String constraintName, Score<?> constraintWeight, int inputStoreIndex) {
        this.constraintId = ConstraintMatchTotal.composeConstraintId((String)constraintPackage, (String)constraintName);
        this.constraintWeight = constraintWeight;
        this.inputStoreIndex = inputStoreIndex;
    }

    public final void insert(Tuple_ tuple) {
        Object[] tupleStore = tuple.getStore();
        if (tupleStore[this.inputStoreIndex] != null) {
            throw new IllegalStateException("Impossible state: the input for the tuple (" + tuple + ") was already added in the tupleStore.");
        }
        UndoScoreImpacter undoScoreImpacter = this.impact(tuple);
        tupleStore[this.inputStoreIndex] = undoScoreImpacter;
    }

    protected abstract UndoScoreImpacter impact(Tuple_ var1);

    public final void retract(Tuple_ tuple) {
        Object[] tupleStore = tuple.getStore();
        UndoScoreImpacter undoScoreImpacter = (UndoScoreImpacter)tupleStore[this.inputStoreIndex];
        if (undoScoreImpacter != null) {
            undoScoreImpacter.run();
            tupleStore[this.inputStoreIndex] = null;
        }
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(" + this.constraintId + ") with constraintWeight (" + this.constraintWeight + ")";
    }
}

