/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.common.index;

import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.optaplanner.constraint.streams.bavet.common.Tuple;
import org.optaplanner.constraint.streams.bavet.common.index.IndexProperties;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.core.impl.score.stream.JoinerType;

final class ComparisonIndexer<Tuple_ extends Tuple, Value_, Key_ extends Comparable<Key_>>
implements Indexer<Tuple_, Value_> {
    private final SubmapBiFunction<Tuple_, Value_, Key_> submapExtractor;
    private final Function<IndexProperties, Key_> comparisonIndexPropertyFunction;
    private final Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier;
    private final NavigableMap<Key_, Indexer<Tuple_, Value_>> comparisonMap = new TreeMap(new KeyComparator());

    public ComparisonIndexer(JoinerType comparisonJoinerType, Function<IndexProperties, Key_> comparisonIndexPropertyFunction, Supplier<Indexer<Tuple_, Value_>> downstreamIndexerSupplier) {
        this.submapExtractor = this.getSubmapExtractor(comparisonJoinerType);
        this.comparisonIndexPropertyFunction = Objects.requireNonNull(comparisonIndexPropertyFunction);
        this.downstreamIndexerSupplier = Objects.requireNonNull(downstreamIndexerSupplier);
    }

    @Override
    public void put(IndexProperties indexProperties, Tuple_ tuple, Value_ value) {
        Comparable comparisonIndexProperty = (Comparable)this.comparisonIndexPropertyFunction.apply(indexProperties);
        Indexer downstreamIndexer = this.comparisonMap.computeIfAbsent(comparisonIndexProperty, k -> this.downstreamIndexerSupplier.get());
        downstreamIndexer.put(indexProperties, tuple, value);
    }

    @Override
    public Value_ remove(IndexProperties indexProperties, Tuple_ tuple) {
        Comparable comparisonIndexProperty = (Comparable)this.comparisonIndexPropertyFunction.apply(indexProperties);
        Indexer downstreamIndexer = (Indexer)this.comparisonMap.get(comparisonIndexProperty);
        if (downstreamIndexer == null) {
            throw new IllegalStateException("Impossible state: the tuple (" + tuple + ") with indexProperties (" + indexProperties + ") doesn't exist in the indexer.");
        }
        Object value = downstreamIndexer.remove(indexProperties, tuple);
        if (downstreamIndexer.isEmpty()) {
            this.comparisonMap.remove(comparisonIndexProperty);
        }
        return value;
    }

    private SubmapBiFunction<Tuple_, Value_, Key_> getSubmapExtractor(JoinerType comparisonJoinerType) {
        switch (comparisonJoinerType) {
            case LESS_THAN: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.headMap(comparisonIndexProperty, false);
            }
            case LESS_THAN_OR_EQUAL: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.headMap(comparisonIndexProperty, true);
            }
            case GREATER_THAN: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.tailMap(comparisonIndexProperty, false);
            }
            case GREATER_THAN_OR_EQUAL: {
                return (comparisonMap, comparisonIndexProperty) -> comparisonMap.tailMap(comparisonIndexProperty, true);
            }
        }
        throw new IllegalStateException("Impossible state: the comparisonJoinerType (" + comparisonJoinerType + ") is not one of the 4 comparison types.");
    }

    @Override
    public void visit(IndexProperties indexProperties, BiConsumer<Tuple_, Value_> tupleValueVisitor) {
        Comparable comparisonIndexProperty = (Comparable)this.comparisonIndexPropertyFunction.apply(indexProperties);
        Map selectedComparisonMap = (Map)this.submapExtractor.apply(this.comparisonMap, comparisonIndexProperty);
        if (selectedComparisonMap.isEmpty()) {
            return;
        }
        for (Indexer indexer : selectedComparisonMap.values()) {
            indexer.visit(indexProperties, tupleValueVisitor);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.comparisonMap.isEmpty();
    }

    private static interface SubmapBiFunction<Tuple_ extends Tuple, Value_, Key_ extends Comparable<Key_>>
    extends BiFunction<NavigableMap<Key_, Indexer<Tuple_, Value_>>, Key_, Map<Key_, Indexer<Tuple_, Value_>>> {
    }

    private static final class KeyComparator<Key_ extends Comparable<Key_>>
    implements Comparator<Key_> {
        private KeyComparator() {
        }

        @Override
        public int compare(Key_ o1, Key_ o2) {
            return o1.compareTo(o2);
        }
    }
}

