/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.quad.BavetAbstractQuadConstraintStream;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.core.api.function.QuadPredicate;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetFilterQuadConstraintStream<Solution_, A, B, C, D>
extends BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> {
    private final BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent;
    private final QuadPredicate<A, B, C, D> predicate;

    public BavetFilterQuadConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractQuadConstraintStream<Solution_, A, B, C, D> parent, QuadPredicate<A, B, C, D> predicate) {
        super(constraintFactory, parent.getRetrievalSemantics());
        this.parent = parent;
        this.predicate = predicate;
        if (predicate == null) {
            throw new IllegalArgumentException("The predicate (null) cannot be null.");
        }
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parent.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parent.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parent.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        buildHelper.putInsertRetract(this, new ConditionalQuadConsumer<A, B, C, D>(this.predicate, insert), retract);
    }

    public int hashCode() {
        return Objects.hash(this.parent, this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BavetFilterQuadConstraintStream) {
            BavetFilterQuadConstraintStream other = (BavetFilterQuadConstraintStream)o;
            return this.parent == other.parent && this.predicate == other.predicate;
        }
        return false;
    }

    public String toString() {
        return "Filter() with " + this.childStreamList.size() + " children";
    }

    private static final class ConditionalQuadConsumer<A, B, C, D>
    implements Consumer<QuadTuple<A, B, C, D>> {
        private final QuadPredicate<A, B, C, D> predicate;
        private final Consumer<QuadTuple<A, B, C, D>> consumer;

        public ConditionalQuadConsumer(QuadPredicate<A, B, C, D> predicate, Consumer<QuadTuple<A, B, C, D>> consumer) {
            this.predicate = predicate;
            this.consumer = consumer;
        }

        @Override
        public void accept(QuadTuple<A, B, C, D> tuple) {
            if (this.predicate.test(tuple.factA, tuple.factB, tuple.factC, tuple.factD)) {
                this.consumer.accept(tuple);
            }
        }
    }
}

