/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.quad;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.bi.BiTuple;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.quad.AbstractGroupQuadNode;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.core.api.function.QuadFunction;
import org.optaplanner.core.impl.util.Pair;

final class Group2Mapping0CollectorQuadNode<OldA, OldB, OldC, OldD, A, B>
extends AbstractGroupQuadNode<OldA, OldB, OldC, OldD, BiTuple<A, B>, Pair<A, B>, Void, Void> {
    private final QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA;
    private final QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB;
    private final int outputStoreSize;

    public Group2Mapping0CollectorQuadNode(QuadFunction<OldA, OldB, OldC, OldD, A> groupKeyMappingA, QuadFunction<OldA, OldB, OldC, OldD, B> groupKeyMappingB, int groupStoreIndex, Consumer<BiTuple<A, B>> nextNodesInsert, Consumer<BiTuple<A, B>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, null, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Pair<A, B> createGroupKey(QuadTuple<OldA, OldB, OldC, OldD> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object oldD = tuple.factD;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC, oldD);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC, oldD);
        return Pair.of((Object)a, (Object)b);
    }

    @Override
    protected BiTuple<A, B> createOutTuple(Group<BiTuple<A, B>, Pair<A, B>, Void> group) {
        Pair key = (Pair)group.groupKey;
        return new BiTuple<Object, Object>(key.getKey(), key.getValue(), this.outputStoreSize);
    }

    public String toString() {
        return "GroupQuadNode 2+0";
    }
}

