/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.tri;

import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.common.Group;
import org.optaplanner.constraint.streams.bavet.quad.QuadTuple;
import org.optaplanner.constraint.streams.bavet.tri.AbstractGroupTriNode;
import org.optaplanner.constraint.streams.bavet.tri.TriTuple;
import org.optaplanner.core.api.function.TriFunction;
import org.optaplanner.core.api.score.stream.tri.TriConstraintCollector;
import org.optaplanner.core.impl.util.Triple;

final class Group3Mapping1CollectorTriNode<OldA, OldB, OldC, A, B, C, D, ResultContainer_>
extends AbstractGroupTriNode<OldA, OldB, OldC, QuadTuple<A, B, C, D>, Triple<A, B, C>, ResultContainer_, D> {
    private final TriFunction<OldA, OldB, OldC, A> groupKeyMappingA;
    private final TriFunction<OldA, OldB, OldC, B> groupKeyMappingB;
    private final TriFunction<OldA, OldB, OldC, C> groupKeyMappingC;
    private final int outputStoreSize;

    public Group3Mapping1CollectorTriNode(TriFunction<OldA, OldB, OldC, A> groupKeyMappingA, TriFunction<OldA, OldB, OldC, B> groupKeyMappingB, TriFunction<OldA, OldB, OldC, C> groupKeyMappingC, int groupStoreIndex, TriConstraintCollector<OldA, OldB, OldC, ResultContainer_, D> collector, Consumer<QuadTuple<A, B, C, D>> nextNodesInsert, Consumer<QuadTuple<A, B, C, D>> nextNodesRetract, int outputStoreSize) {
        super(groupStoreIndex, collector, nextNodesInsert, nextNodesRetract);
        this.groupKeyMappingA = groupKeyMappingA;
        this.groupKeyMappingB = groupKeyMappingB;
        this.groupKeyMappingC = groupKeyMappingC;
        this.outputStoreSize = outputStoreSize;
    }

    @Override
    protected Triple<A, B, C> createGroupKey(TriTuple<OldA, OldB, OldC> tuple) {
        Object oldA = tuple.factA;
        Object oldB = tuple.factB;
        Object oldC = tuple.factC;
        Object a = this.groupKeyMappingA.apply(oldA, oldB, oldC);
        Object b = this.groupKeyMappingB.apply(oldA, oldB, oldC);
        Object c = this.groupKeyMappingC.apply(oldA, oldB, oldC);
        return Triple.of((Object)a, (Object)b, (Object)c);
    }

    @Override
    protected QuadTuple<A, B, C, D> createOutTuple(Group<QuadTuple<A, B, C, D>, Triple<A, B, C>, ResultContainer_> group) {
        Triple groupKey = (Triple)group.groupKey;
        Object d = this.finisher.apply(group.resultContainer);
        return new QuadTuple(groupKey.getA(), groupKey.getB(), groupKey.getC(), d, this.outputStoreSize);
    }

    public String toString() {
        return "GroupTriNode 3+1";
    }
}

