/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.constraint.streams.bavet.uni;

import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.optaplanner.constraint.streams.bavet.BavetConstraintFactory;
import org.optaplanner.constraint.streams.bavet.common.BavetAbstractConstraintStream;
import org.optaplanner.constraint.streams.bavet.common.NodeBuildHelper;
import org.optaplanner.constraint.streams.bavet.common.index.Indexer;
import org.optaplanner.constraint.streams.bavet.common.index.IndexerFactory;
import org.optaplanner.constraint.streams.bavet.common.index.JoinerUtils;
import org.optaplanner.constraint.streams.bavet.uni.BavetAbstractUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.BavetIfExistsBridgeUniConstraintStream;
import org.optaplanner.constraint.streams.bavet.uni.IfExistsUniWithUniNode;
import org.optaplanner.constraint.streams.bi.DefaultBiJoiner;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.stream.ConstraintStream;

public final class BavetIfExistsUniConstraintStream<Solution_, A, B>
extends BavetAbstractUniConstraintStream<Solution_, A> {
    private final BavetAbstractUniConstraintStream<Solution_, A> parentA;
    private final BavetIfExistsBridgeUniConstraintStream<Solution_, B> parentBridgeB;
    private final boolean shouldExist;
    private final DefaultBiJoiner<A, B> joiner;
    private final BiPredicate<A, B> filtering;

    public BavetIfExistsUniConstraintStream(BavetConstraintFactory<Solution_> constraintFactory, BavetAbstractUniConstraintStream<Solution_, A> parentA, BavetIfExistsBridgeUniConstraintStream<Solution_, B> parentBridgeB, boolean shouldExist, DefaultBiJoiner<A, B> joiner, BiPredicate<A, B> filtering) {
        super(constraintFactory, parentA.getRetrievalSemantics());
        this.parentA = parentA;
        this.parentBridgeB = parentBridgeB;
        this.shouldExist = shouldExist;
        this.joiner = joiner;
        this.filtering = filtering;
    }

    @Override
    public boolean guaranteesDistinct() {
        return this.parentA.guaranteesDistinct();
    }

    @Override
    public void collectActiveConstraintStreams(Set<BavetAbstractConstraintStream<Solution_>> constraintStreamSet) {
        this.parentA.collectActiveConstraintStreams(constraintStreamSet);
        this.parentBridgeB.collectActiveConstraintStreams(constraintStreamSet);
        constraintStreamSet.add(this);
    }

    @Override
    public ConstraintStream getTupleSource() {
        return this.parentA.getTupleSource();
    }

    @Override
    public <Score_ extends Score<Score_>> void buildNode(NodeBuildHelper<Score_> buildHelper) {
        int inputStoreIndexA = buildHelper.reserveTupleStoreIndex(this.parentA.getTupleSource());
        int inputStoreIndexB = buildHelper.reserveTupleStoreIndex(this.parentBridgeB.getTupleSource());
        Consumer insert = buildHelper.getAggregatedInsert(this.childStreamList);
        Consumer retract = buildHelper.getAggregatedRetract(this.childStreamList);
        IndexerFactory indexerFactory = new IndexerFactory(this.joiner);
        Indexer indexerA = indexerFactory.buildIndexer(true);
        Indexer indexerB = indexerFactory.buildIndexer(false);
        IfExistsUniWithUniNode node = new IfExistsUniWithUniNode(this.shouldExist, JoinerUtils.combineLeftMappings(this.joiner), JoinerUtils.combineRightMappings(this.joiner), inputStoreIndexA, inputStoreIndexB, insert, retract, indexerA, indexerB, this.filtering);
        buildHelper.addNode(node);
        buildHelper.putInsertRetract(this, node::insertLeft, node::retractLeft);
        buildHelper.putInsertRetract(this.parentBridgeB, node::insertRight, node::retractRight);
    }

    public String toString() {
        return "IfExists() with " + this.childStreamList.size() + " children";
    }
}

