/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.event;

import java.util.Iterator;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.optaplanner.core.impl.solver.event.AbstractEventSupport;
import org.optaplanner.core.impl.solver.scope.SolverScope;

public class SolverEventSupport<Solution_>
extends AbstractEventSupport<SolverEventListener<Solution_>> {
    private final Solver<Solution_> solver;

    public SolverEventSupport(Solver<Solution_> solver) {
        this.solver = solver;
    }

    public void fireBestSolutionChanged(SolverScope<Solution_> solverScope, Solution_ newBestSolution) {
        Iterator it = this.eventListenerSet.iterator();
        long timeMillisSpent = solverScope.getBestSolutionTimeMillisSpent();
        Score bestScore = solverScope.getBestScore();
        if (it.hasNext()) {
            BestSolutionChangedEvent<Solution_> event = new BestSolutionChangedEvent<Solution_>(this.solver, timeMillisSpent, newBestSolution, bestScore);
            do {
                ((SolverEventListener)it.next()).bestSolutionChanged(event);
            } while (it.hasNext());
        }
    }
}

