/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cheaptime.swingui;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JCheckBox;
import org.apache.commons.lang3.tuple.Pair;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CombinedRangeXYPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.util.ShapeUtils;
import org.jfree.data.time.FixedMillisecond;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.ohlc.OHLCSeries;
import org.jfree.data.time.ohlc.OHLCSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.optaplanner.examples.cheaptime.domain.CheapTimeSolution;
import org.optaplanner.examples.cheaptime.domain.Machine;
import org.optaplanner.examples.cheaptime.domain.Period;
import org.optaplanner.examples.cheaptime.domain.Resource;
import org.optaplanner.examples.cheaptime.domain.Task;
import org.optaplanner.examples.cheaptime.domain.TaskAssignment;
import org.optaplanner.examples.cheaptime.domain.TaskRequirement;
import org.optaplanner.examples.common.domain.AbstractPersistable;
import org.optaplanner.examples.common.swingui.SolutionPanel;
import org.optaplanner.swing.impl.TangoColorFactory;

public class CheapTimePanel
extends SolutionPanel<CheapTimeSolution> {
    public static final String LOGO_PATH = "/org/optaplanner/examples/cheaptime/swingui/cheapTimeLogo.png";
    private static final Comparator<TaskAssignment> STABLE_COMPARATOR = Comparator.comparing(a -> a.getTask().getStartPeriodRangeFrom()).thenComparingInt(a -> a.getTask().getStartPeriodRangeTo()).thenComparingInt(a -> a.getTask().getDuration()).thenComparingLong(AbstractPersistable::getId);
    private static final Comparator<TaskAssignment> GROUP_BY_MACHINE_COMPARATOR = Comparator.comparing(TaskAssignment::getMachine, Comparator.nullsFirst(Comparator.comparing(AbstractPersistable::getId))).thenComparing(TaskAssignment::getStartPeriod, Comparator.nullsFirst(Comparator.comparing(Function.identity()))).thenComparingInt(a -> a.getTask().getDuration()).thenComparingLong(AbstractPersistable::getId);
    private final JCheckBox groupByMachineCheckBox;

    public CheapTimePanel() {
        this.setLayout(new BorderLayout());
        this.groupByMachineCheckBox = new JCheckBox("Group by assigned machine", false);
        this.groupByMachineCheckBox.setHorizontalAlignment(4);
        this.groupByMachineCheckBox.addActionListener(e -> {
            this.updatePanel((CheapTimeSolution)this.getSolution());
            this.validate();
        });
    }

    @Override
    public void resetPanel(CheapTimeSolution solution) {
        this.removeAll();
        this.add((Component)this.groupByMachineCheckBox, "North");
        ChartPanel chartPanel = new ChartPanel(this.createChart(solution));
        this.add((Component)chartPanel, "Center");
    }

    private JFreeChart createChart(CheapTimeSolution solution) {
        TangoColorFactory tangoColorFactory = new TangoColorFactory();
        NumberAxis rangeAxis = new NumberAxis("Period");
        rangeAxis.setRange(-0.5, (double)solution.getGlobalPeriodRangeTo() + 0.5);
        XYPlot taskAssignmentPlot = this.createTaskAssignmentPlot(tangoColorFactory, solution);
        XYPlot periodCostPlot = this.createPeriodCostPlot(solution);
        XYPlot capacityPlot = this.createAvailableCapacityPlot(tangoColorFactory, solution);
        CombinedRangeXYPlot combinedPlot = new CombinedRangeXYPlot((ValueAxis)rangeAxis);
        combinedPlot.add(taskAssignmentPlot, 5);
        combinedPlot.add(periodCostPlot, 1);
        combinedPlot.add(capacityPlot, 1);
        combinedPlot.setOrientation(PlotOrientation.HORIZONTAL);
        return new JFreeChart("Cheap Power Time Scheduling", JFreeChart.DEFAULT_TITLE_FONT, (Plot)combinedPlot, true);
    }

    private XYPlot createTaskAssignmentPlot(TangoColorFactory tangoColorFactory, CheapTimeSolution solution) {
        OHLCSeriesCollection seriesCollection = new OHLCSeriesCollection();
        LinkedHashMap<Machine, OHLCSeries> machineSeriesMap = new LinkedHashMap<Machine, OHLCSeries>(solution.getMachineList().size());
        HighLowRenderer renderer = new HighLowRenderer();
        renderer.setTickLength(0.0);
        int seriesIndex = 0;
        OHLCSeries unassignedProjectSeries = new OHLCSeries((Comparable)((Object)"Unassigned"));
        seriesCollection.addSeries(unassignedProjectSeries);
        machineSeriesMap.put(null, unassignedProjectSeries);
        renderer.setSeriesStroke(seriesIndex, (Stroke)new BasicStroke(3.0f));
        renderer.setSeriesPaint(seriesIndex, (Paint)TangoColorFactory.SCARLET_1);
        ++seriesIndex;
        for (Machine machine : solution.getMachineList()) {
            OHLCSeries machineSeries = new OHLCSeries((Comparable)((Object)machine.getLabel()));
            seriesCollection.addSeries(machineSeries);
            machineSeriesMap.put(machine, machineSeries);
            renderer.setSeriesStroke(seriesIndex, (Stroke)new BasicStroke(3.0f));
            renderer.setSeriesPaint(seriesIndex, (Paint)tangoColorFactory.pickColor((Object)machine));
            ++seriesIndex;
        }
        List taskAssignmentList = solution.getTaskAssignmentList().stream().sorted(this.groupByMachineCheckBox.isSelected() ? GROUP_BY_MACHINE_COMPARATOR : STABLE_COMPARATOR).collect(Collectors.toList());
        int pixelIndex = 0;
        for (TaskAssignment taskAssignment : taskAssignmentList) {
            Task task = taskAssignment.getTask();
            Integer startPeriod = taskAssignment.getStartPeriod();
            Integer endPeriod = taskAssignment.getEndPeriod();
            if (startPeriod == null) {
                startPeriod = task.getStartPeriodRangeFrom();
                endPeriod = startPeriod + task.getDuration();
            }
            OHLCSeries machineSeries = (OHLCSeries)machineSeriesMap.get(taskAssignment.getMachine());
            machineSeries.add((RegularTimePeriod)new FixedMillisecond((long)pixelIndex), (double)task.getStartPeriodRangeFrom(), (double)startPeriod.intValue(), (double)endPeriod.intValue(), (double)(task.getStartPeriodRangeTo() + task.getDuration()));
            ++pixelIndex;
        }
        NumberAxis domainAxis = new NumberAxis("Task");
        domainAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        domainAxis.setRange(-0.5, (double)taskAssignmentList.size() - 0.5);
        domainAxis.setInverted(true);
        return new XYPlot((XYDataset)seriesCollection, (ValueAxis)domainAxis, null, (XYItemRenderer)renderer);
    }

    private XYPlot createPeriodCostPlot(CheapTimeSolution solution) {
        XYSeries series = new XYSeries((Comparable)((Object)"Power price"));
        for (Period period : solution.getPeriodList()) {
            series.add((double)period.getPowerPriceMicros() / 1000000.0, (double)period.getIndex());
        }
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        seriesCollection.addSeries(series);
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1);
        renderer.setSeriesPaint(0, (Paint)TangoColorFactory.ORANGE_1);
        renderer.setSeriesShape(0, ShapeUtils.createDiamond((float)2.0f));
        NumberAxis domainAxis = new NumberAxis("Power price");
        return new XYPlot((XYDataset)seriesCollection, (ValueAxis)domainAxis, null, (XYItemRenderer)renderer);
    }

    private XYPlot createAvailableCapacityPlot(TangoColorFactory tangoColorFactory, CheapTimeSolution solution) {
        LinkedHashMap<Pair, List> availableMap = new LinkedHashMap<Pair, List>();
        for (Machine machine : solution.getMachineList()) {
            for (Resource resource : solution.getResourceList()) {
                ArrayList<Integer> machineAvailableList2 = new ArrayList<Integer>(solution.getGlobalPeriodRangeTo());
                for (int period = 0; period < solution.getGlobalPeriodRangeTo(); ++period) {
                    machineAvailableList2.add(machine.getCapacity(resource));
                }
                availableMap.put(Pair.of((Object)machine, (Object)resource), machineAvailableList2);
            }
        }
        for (TaskAssignment taskAssignment : solution.getTaskAssignmentList()) {
            Machine machine = taskAssignment.getMachine();
            Integer startPeriod = taskAssignment.getStartPeriod();
            if (machine == null || startPeriod == null) continue;
            Task task = taskAssignment.getTask();
            List<TaskRequirement> taskRequirementList = task.getTaskRequirementList();
            for (int i = 0; i < taskRequirementList.size(); ++i) {
                TaskRequirement taskRequirement = taskRequirementList.get(i);
                Resource resource = solution.getResourceList().get(i);
                Pair machineResourcePair2 = Pair.of((Object)machine, (Object)resource);
                List machineAvailableList3 = (List)availableMap.get(machineResourcePair2);
                for (int j = 0; j < task.getDuration(); ++j) {
                    int period = j + taskAssignment.getStartPeriod();
                    int available = (Integer)machineAvailableList3.get(period);
                    machineAvailableList3.set(period, available - taskRequirement.getResourceUsage());
                }
            }
        }
        LinkedHashMap<Machine, XYSeries> machineSeriesMap = new LinkedHashMap<Machine, XYSeries>();
        for (Machine machine : solution.getMachineList()) {
            XYSeries machineSeries = new XYSeries((Comparable)((Object)machine.getLabel()));
            machineSeriesMap.put(machine, machineSeries);
        }
        availableMap.forEach((machineResourcePair, machineAvailableList) -> {
            for (int period = 0; period < solution.getGlobalPeriodRangeTo(); ++period) {
                int available = (Integer)machineAvailableList.get(period);
                ((XYSeries)machineSeriesMap.get(machineResourcePair.getKey())).add((double)available, (double)period);
            }
        });
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        StandardXYItemRenderer renderer = new StandardXYItemRenderer(1);
        machineSeriesMap.forEach((arg_0, arg_1) -> CheapTimePanel.lambda$createAvailableCapacityPlot$6(xYSeriesCollection, (XYItemRenderer)renderer, tangoColorFactory, arg_0, arg_1));
        NumberAxis domainAxis = new NumberAxis("Capacity");
        return new XYPlot((XYDataset)xYSeriesCollection, (ValueAxis)domainAxis, null, (XYItemRenderer)renderer);
    }

    private static /* synthetic */ void lambda$createAvailableCapacityPlot$6(XYSeriesCollection seriesCollection, XYItemRenderer renderer, TangoColorFactory tangoColorFactory, Machine machine, XYSeries machineSeries) {
        int seriesIndex = machine.getIndex();
        seriesCollection.addSeries(machineSeries);
        renderer.setSeriesPaint(seriesIndex, (Paint)tangoColorFactory.pickColor((Object)machine));
        renderer.setSeriesShape(seriesIndex, ShapeUtils.createDiamond((float)1.5f));
        renderer.setSeriesVisibleInLegend(seriesIndex, Boolean.valueOf(false));
    }
}

