/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.batchscheduling.score;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.optaplanner.core.api.score.buildin.bendablelong.BendableLongScore;
import org.optaplanner.core.api.score.calculator.IncrementalScoreCalculator;
import org.optaplanner.examples.batchscheduling.domain.Allocation;
import org.optaplanner.examples.batchscheduling.domain.AllocationPath;
import org.optaplanner.examples.batchscheduling.domain.Batch;
import org.optaplanner.examples.batchscheduling.domain.BatchSchedule;
import org.optaplanner.examples.batchscheduling.domain.RoutePath;
import org.optaplanner.examples.batchscheduling.domain.Segment;

public class BatchSchedulingIncrementalScoreCalculator
implements IncrementalScoreCalculator<BatchSchedule, BendableLongScore> {
    private long hard0Score = 0L;
    private long hard1Score = 0L;
    private long hard2Score = 0L;
    private long soft0Score = 0L;
    private long soft1Score = 0L;
    private Map<Long, String> batchRoutePathMap;
    private Map<Long, Long> batchCurrentPenaltyValueMap;
    private Map<Long, Long> batchOtherPenaltyValueMap;
    private Map<Long, Long> batchEndTimeMap;
    private Map<Long, Long> allocationDelayMap;
    private Map<String, Long> segmentOverlapMap;
    private Map<Long, Long> allocationStartInjectionTimeMap;
    private Map<Long, Long> allocationEndInjectionTimeMap;
    private Map<Long, Long> allocationStartDeliveryTimeMap;
    private Map<Long, Long> allocationEndDeliveryTimeMap;
    private Map<Long, Segment> segmentMap;
    private Map<String, Boolean> segmentStringMap;

    private static String generateCompositeKey(String key1, String key2) {
        return key1 + "#" + key2;
    }

    public void resetWorkingSolution(BatchSchedule schedule) {
        this.batchRoutePathMap = new HashMap<Long, String>();
        this.segmentMap = new HashMap<Long, Segment>();
        this.segmentStringMap = new HashMap<String, Boolean>();
        this.batchOtherPenaltyValueMap = new HashMap<Long, Long>();
        this.batchCurrentPenaltyValueMap = new HashMap<Long, Long>();
        this.batchEndTimeMap = new HashMap<Long, Long>();
        this.segmentOverlapMap = new HashMap<String, Long>();
        this.allocationDelayMap = new HashMap<Long, Long>();
        this.allocationStartInjectionTimeMap = new HashMap<Long, Long>();
        this.allocationEndInjectionTimeMap = new HashMap<Long, Long>();
        this.allocationStartDeliveryTimeMap = new HashMap<Long, Long>();
        this.allocationEndDeliveryTimeMap = new HashMap<Long, Long>();
        this.hard0Score = 0L;
        this.hard1Score = 0L;
        this.hard2Score = 0L;
        this.soft0Score = 0L;
        this.soft1Score = 0L;
        for (Batch batch : schedule.getBatchList()) {
            this.batchRoutePathMap.put(batch.getId(), null);
            this.batchOtherPenaltyValueMap.put(batch.getId(), 0L);
            this.batchCurrentPenaltyValueMap.put(batch.getId(), 0L);
            this.batchEndTimeMap.put(batch.getId(), 0L);
            for (RoutePath routePath : batch.getRoutePathList()) {
                for (Segment segment : routePath.getSegmentList()) {
                    this.segmentMap.put(segment.getId(), segment);
                    this.segmentStringMap.put(segment.getName(), true);
                }
            }
        }
        for (AllocationPath allocationPath : schedule.getAllocationPathList()) {
            this.insert(allocationPath);
        }
        for (Allocation allocation : schedule.getAllocationList()) {
            this.insert(allocation);
        }
    }

    public void beforeEntityAdded(Object entity) {
    }

    public void afterEntityAdded(Object entity) {
    }

    public void beforeVariableChanged(Object entity, String variableName) {
        if (entity instanceof Allocation) {
            if (!variableName.equals("predecessorsDoneDate")) {
                this.retract((Allocation)entity);
            } else {
                this.retractPredecessorDate((Allocation)entity);
            }
        } else if (entity instanceof AllocationPath) {
            this.retract((AllocationPath)entity);
        }
    }

    public void afterVariableChanged(Object entity, String variableName) {
        if (entity instanceof Allocation) {
            if (!variableName.equals("predecessorsDoneDate")) {
                this.insert((Allocation)entity);
            } else {
                this.insertPredecessorDate((Allocation)entity);
            }
        } else if (entity instanceof AllocationPath) {
            this.insert((AllocationPath)entity);
        }
    }

    public void beforeEntityRemoved(Object entity) {
    }

    public void afterEntityRemoved(Object entity) {
    }

    private void insert(AllocationPath allocationPath) {
        Long allocationPathBatchId = allocationPath.getBatch().getId();
        Long oldOtherPenaltyValue = this.batchOtherPenaltyValueMap.get(allocationPathBatchId);
        Long oldCurrentPenaltyValue = this.batchCurrentPenaltyValueMap.get(allocationPathBatchId);
        long newOtherPenaltyValue = 0L;
        long newCurrentPenaltyValue = 0L;
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            Long allocationSegmentId = segmentEntry.getKey();
            Segment mainSegment = segmentEntry.getValue();
            if (!Objects.equals(mainSegment.getBatch().getId(), allocationPathBatchId)) continue;
            if (allocationPath.getRoutePath() == null) {
                ++newCurrentPenaltyValue;
                continue;
            }
            Long allocationDelay = this.allocationDelayMap.get(allocationSegmentId);
            if (!Objects.equals(mainSegment.getRoutePath().getId(), allocationPath.getRoutePath().getId())) {
                if (allocationDelay == null) continue;
                ++newOtherPenaltyValue;
                continue;
            }
            if (allocationDelay == null) {
                ++newCurrentPenaltyValue;
                continue;
            }
            this.computeOverlap(allocationPathBatchId, allocationSegmentId, segmentEntry.getValue().getName(), this.allocationStartInjectionTimeMap.get(allocationSegmentId), this.allocationEndInjectionTimeMap.get(allocationSegmentId), this.allocationStartDeliveryTimeMap.get(allocationSegmentId), this.allocationEndDeliveryTimeMap.get(allocationSegmentId));
        }
        if (oldOtherPenaltyValue == 0L && newOtherPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldOtherPenaltyValue > 0L && newOtherPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        if (oldCurrentPenaltyValue == 0L && newCurrentPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldCurrentPenaltyValue > 0L && newCurrentPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        if (allocationPath.getRoutePath() != null) {
            this.batchRoutePathMap.put(allocationPathBatchId, allocationPath.getRoutePath().getPath());
        } else {
            this.batchRoutePathMap.remove(allocationPathBatchId);
        }
        this.updateBatchEndDate(allocationPath);
        this.batchOtherPenaltyValueMap.put(allocationPathBatchId, newOtherPenaltyValue);
        this.batchCurrentPenaltyValueMap.put(allocationPathBatchId, newCurrentPenaltyValue);
        this.hard1Score = this.hard1Score - newOtherPenaltyValue - newCurrentPenaltyValue + oldOtherPenaltyValue + oldCurrentPenaltyValue;
        this.soft0Score = -this.getMaxEndTime();
        this.soft1Score = -this.computeRoutePathSegmentOverlap();
    }

    private void retract(AllocationPath allocationPath) {
        Long allocationBatchId = allocationPath.getBatch().getId();
        Long oldOtherPenaltyValue = this.batchOtherPenaltyValueMap.get(allocationBatchId);
        Long oldCurrentPenaltyValue = this.batchCurrentPenaltyValueMap.get(allocationBatchId);
        long newOtherPenaltyValue = 0L;
        long newCurrentPenaltyValue = 0L;
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            if (!Objects.equals(segmentEntry.getValue().getBatch().getId(), allocationBatchId)) continue;
            ++newCurrentPenaltyValue;
            for (Map.Entry<Long, Segment> segmentEntry2 : this.segmentMap.entrySet()) {
                String segmentId2;
                String segmentId1;
                String compositeKey;
                Long segmentOverlap;
                if (Objects.equals(segmentEntry2.getValue().getBatch().getId(), allocationBatchId) || !segmentEntry2.getValue().getName().equals(segmentEntry.getValue().getName()) || (segmentOverlap = this.segmentOverlapMap.get(compositeKey = BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(segmentId1 = segmentEntry.getKey().toString(), segmentId2 = segmentEntry2.getKey().toString()))) == null) continue;
                this.hard2Score += 2L * segmentOverlap;
                this.segmentOverlapMap.remove(compositeKey);
                this.segmentOverlapMap.remove(BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(segmentId2, segmentId1));
            }
        }
        if (oldOtherPenaltyValue > 0L) {
            ++this.hard0Score;
        }
        if (oldCurrentPenaltyValue == 0L && newCurrentPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldCurrentPenaltyValue > 0L && newCurrentPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        this.batchRoutePathMap.remove(allocationBatchId);
        this.batchOtherPenaltyValueMap.put(allocationBatchId, newOtherPenaltyValue);
        this.batchCurrentPenaltyValueMap.put(allocationBatchId, newCurrentPenaltyValue);
        this.hard1Score = this.hard1Score - newOtherPenaltyValue - newCurrentPenaltyValue + oldOtherPenaltyValue + oldCurrentPenaltyValue;
    }

    private void insert(Allocation allocation) {
        boolean hasDelay;
        Long oldOtherPenaltyValue;
        Long oldCurrentPenaltyValue;
        Long allocationBatchId = allocation.getBatch().getId();
        Long allocationSegmentId = allocation.getSegment().getId();
        if (this.batchRoutePathMap.get(allocationBatchId) == null) {
            this.allocationDelayMap.put(allocationSegmentId, allocation.getDelay());
            this.allocationStartInjectionTimeMap.put(allocationSegmentId, allocation.getStartInjectionTime());
            this.allocationEndInjectionTimeMap.put(allocationSegmentId, allocation.getEndInjectionTime());
            this.allocationStartDeliveryTimeMap.put(allocationSegmentId, allocation.getStartDeliveryTime());
            this.allocationEndDeliveryTimeMap.put(allocationSegmentId, allocation.getEndDeliveryTime());
            return;
        }
        Long newCurrentPenaltyValue = oldCurrentPenaltyValue = this.batchCurrentPenaltyValueMap.get(allocationBatchId);
        Long newOtherPenaltyValue = oldOtherPenaltyValue = this.batchOtherPenaltyValueMap.get(allocationBatchId);
        boolean computeOverLap = false;
        boolean hadDelay = allocation.getDelay() != null;
        Long allocationDelay = this.allocationDelayMap.get(allocationSegmentId);
        boolean bl = hasDelay = allocationDelay != null;
        if (allocation.getRoutePath().getPath().equals(this.batchRoutePathMap.get(allocationBatchId))) {
            if (hadDelay && !hasDelay) {
                newCurrentPenaltyValue = newCurrentPenaltyValue - 1L;
                if (allocation.getStartInjectionTime() != null) {
                    computeOverLap = true;
                }
            } else if (!hadDelay && hasDelay) {
                newCurrentPenaltyValue = newCurrentPenaltyValue + 1L;
            }
        } else if (hadDelay && !hasDelay) {
            newOtherPenaltyValue = newOtherPenaltyValue + 1L;
        } else if (!hadDelay && hasDelay) {
            newOtherPenaltyValue = newOtherPenaltyValue - 1L;
        }
        if (computeOverLap) {
            this.computeOverlap(allocationBatchId, allocationSegmentId, allocation.getSegment().getName(), allocation.getStartInjectionTime(), allocation.getEndInjectionTime(), allocation.getStartDeliveryTime(), allocation.getEndDeliveryTime());
        }
        if (oldOtherPenaltyValue == 0L && newOtherPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldOtherPenaltyValue > 0L && newOtherPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        if (oldCurrentPenaltyValue == 0L && newCurrentPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldCurrentPenaltyValue > 0L && newCurrentPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        this.allocationDelayMap.put(allocationSegmentId, allocation.getDelay());
        this.allocationStartInjectionTimeMap.put(allocationSegmentId, allocation.getStartInjectionTime());
        this.allocationEndInjectionTimeMap.put(allocationSegmentId, allocation.getEndInjectionTime());
        this.allocationStartDeliveryTimeMap.put(allocationSegmentId, allocation.getStartDeliveryTime());
        this.allocationEndDeliveryTimeMap.put(allocationSegmentId, allocation.getEndDeliveryTime());
        this.updateBatchEndDate(allocation);
        this.batchOtherPenaltyValueMap.put(allocationBatchId, newOtherPenaltyValue);
        this.batchCurrentPenaltyValueMap.put(allocationBatchId, newCurrentPenaltyValue);
        this.hard1Score = this.hard1Score - newOtherPenaltyValue - newCurrentPenaltyValue + oldOtherPenaltyValue + oldCurrentPenaltyValue;
        this.soft0Score = -this.getMaxEndTime();
    }

    private void computeOverlap(Long batchId, Long segmentId, String segmentName, Long mainStartTime1, Long mainEndTime1, Long mainStartTime2, Long mainEndTime2) {
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            Long segmentBatchId;
            if (this.allocationDelayMap.get(segmentEntry.getKey()) == null || Objects.equals(segmentBatchId = segmentEntry.getValue().getBatch().getId(), batchId) || this.batchRoutePathMap.get(segmentBatchId) == null || !segmentEntry.getValue().getRoutePath().getPath().equals(this.batchRoutePathMap.get(segmentBatchId)) || !segmentEntry.getValue().getName().equals(segmentName)) continue;
            Long newOverlapPenaltyValue = 0L;
            Long startInjectionTime = this.allocationStartInjectionTimeMap.get(segmentEntry.getKey());
            Long endInjectionTime = this.allocationEndInjectionTimeMap.get(segmentEntry.getKey());
            if (startInjectionTime <= mainStartTime1 && endInjectionTime >= mainEndTime1) {
                newOverlapPenaltyValue = mainEndTime1 - mainStartTime1;
            } else if (startInjectionTime >= mainStartTime1 && endInjectionTime <= mainEndTime1) {
                newOverlapPenaltyValue = endInjectionTime - startInjectionTime;
            } else if (startInjectionTime <= mainStartTime1 && endInjectionTime > mainStartTime1) {
                newOverlapPenaltyValue = endInjectionTime - mainStartTime1;
            } else if (startInjectionTime < mainEndTime1 && endInjectionTime >= mainEndTime1) {
                newOverlapPenaltyValue = mainEndTime1 - endInjectionTime;
            }
            Long startDeliveryTime = this.allocationStartDeliveryTimeMap.get(segmentEntry.getKey());
            Long endDeliveryTime = this.allocationEndDeliveryTimeMap.get(segmentEntry.getKey());
            if (startDeliveryTime <= mainStartTime2 && endDeliveryTime >= mainEndTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (mainEndTime2 - mainStartTime2);
            } else if (startDeliveryTime >= mainStartTime2 && endDeliveryTime <= mainEndTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (endDeliveryTime - startDeliveryTime);
            } else if (startDeliveryTime <= mainStartTime2 && endDeliveryTime > mainStartTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (endDeliveryTime - mainStartTime2);
            } else if (startDeliveryTime < mainEndTime2 && endDeliveryTime >= mainEndTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (mainEndTime2 - endDeliveryTime);
            }
            if (startInjectionTime >= mainStartTime1 && endDeliveryTime <= mainEndTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (mainEndTime2 - endDeliveryTime);
            }
            if (startInjectionTime <= mainStartTime1 && endDeliveryTime >= mainEndTime2) {
                newOverlapPenaltyValue = newOverlapPenaltyValue + (endDeliveryTime - mainEndTime2);
            }
            if (newOverlapPenaltyValue <= 0L) continue;
            this.hard2Score -= 2L * newOverlapPenaltyValue;
            this.segmentOverlapMap.put(BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(segmentId.toString(), segmentEntry.getKey().toString()), newOverlapPenaltyValue);
            this.segmentOverlapMap.put(BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(segmentEntry.getKey().toString(), segmentId.toString()), newOverlapPenaltyValue);
        }
    }

    private void insertPredecessorDate(Allocation allocation) {
        Long allocationBatchId = allocation.getBatch().getId();
        Long allocationSegmentId = allocation.getSegment().getId();
        if (this.batchRoutePathMap.get(allocationBatchId) == null) {
            this.allocationDelayMap.put(allocationSegmentId, allocation.getDelay());
            this.allocationStartInjectionTimeMap.put(allocationSegmentId, allocation.getStartInjectionTime());
            this.allocationEndInjectionTimeMap.put(allocationSegmentId, allocation.getEndInjectionTime());
            this.allocationStartDeliveryTimeMap.put(allocationSegmentId, allocation.getStartDeliveryTime());
            this.allocationEndDeliveryTimeMap.put(allocationSegmentId, allocation.getEndDeliveryTime());
            return;
        }
        boolean computeOverlap = false;
        if (allocation.getRoutePath().getPath().equals(this.batchRoutePathMap.get(allocationBatchId)) && allocation.getDelay() != null && this.allocationDelayMap.get(allocationSegmentId) == null && allocation.getStartInjectionTime() != null) {
            computeOverlap = true;
        }
        if (computeOverlap) {
            this.computeOverlap(allocationBatchId, allocationSegmentId, allocation.getSegment().getName(), allocation.getStartInjectionTime(), allocation.getEndInjectionTime(), allocation.getStartDeliveryTime(), allocation.getEndDeliveryTime());
        }
        this.allocationDelayMap.put(allocationSegmentId, allocation.getDelay());
        this.allocationStartInjectionTimeMap.put(allocationSegmentId, allocation.getStartInjectionTime());
        this.allocationEndInjectionTimeMap.put(allocationSegmentId, allocation.getEndInjectionTime());
        this.allocationStartDeliveryTimeMap.put(allocationSegmentId, allocation.getStartDeliveryTime());
        this.allocationEndDeliveryTimeMap.put(allocationSegmentId, allocation.getEndDeliveryTime());
        this.updateBatchEndDate(allocation);
        this.soft0Score = -this.getMaxEndTime();
    }

    private void retract(Allocation allocation) {
        boolean hadDelay;
        Long oldOtherPenaltyValue;
        Long oldCurrentPenaltyValue;
        Long allocationBatchId = allocation.getBatch().getId();
        Long allocationSegmentId = allocation.getSegment().getId();
        String allocationSegmentIdString = allocationSegmentId.toString();
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            String subkey;
            String compositeKey;
            Long segmentOverlap;
            if (Objects.equals(segmentEntry.getValue().getBatch().getId(), allocationBatchId) || !segmentEntry.getValue().getName().equals(allocation.getSegment().getName()) || (segmentOverlap = this.segmentOverlapMap.get(compositeKey = BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(allocationSegmentIdString, subkey = segmentEntry.getKey().toString()))) == null) continue;
            this.hard2Score += 2L * segmentOverlap;
            this.segmentOverlapMap.remove(compositeKey);
            this.segmentOverlapMap.remove(BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(subkey, allocationSegmentIdString));
        }
        if (this.batchRoutePathMap.get(allocationBatchId) == null) {
            this.allocationDelayMap.remove(allocationSegmentId);
            this.allocationStartInjectionTimeMap.remove(allocationSegmentId);
            this.allocationEndInjectionTimeMap.remove(allocationSegmentId);
            this.allocationStartDeliveryTimeMap.remove(allocationSegmentId);
            this.allocationEndDeliveryTimeMap.remove(allocationSegmentId);
            return;
        }
        Long newCurrentPenaltyValue = oldCurrentPenaltyValue = this.batchCurrentPenaltyValueMap.get(allocationBatchId);
        Long newOtherPenaltyValue = oldOtherPenaltyValue = this.batchOtherPenaltyValueMap.get(allocationBatchId);
        boolean bl = hadDelay = allocation.getDelay() != null;
        if (allocation.getRoutePath().getPath().equals(this.batchRoutePathMap.get(allocationBatchId))) {
            if (hadDelay && this.allocationDelayMap.get(allocationSegmentId) != null) {
                newCurrentPenaltyValue = newCurrentPenaltyValue + 1L;
            }
        } else if (hadDelay && this.allocationDelayMap.get(allocationSegmentId) != null) {
            newOtherPenaltyValue = newOtherPenaltyValue - 1L;
        }
        if (oldOtherPenaltyValue == 0L && newOtherPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldOtherPenaltyValue > 0L && newOtherPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        if (oldCurrentPenaltyValue == 0L && newCurrentPenaltyValue > 0L) {
            --this.hard0Score;
        }
        if (oldCurrentPenaltyValue > 0L && newCurrentPenaltyValue == 0L) {
            ++this.hard0Score;
        }
        this.batchOtherPenaltyValueMap.put(allocationBatchId, newOtherPenaltyValue);
        this.batchCurrentPenaltyValueMap.put(allocationBatchId, newCurrentPenaltyValue);
        this.allocationDelayMap.remove(allocationSegmentId);
        this.allocationStartInjectionTimeMap.remove(allocationSegmentId);
        this.allocationEndInjectionTimeMap.remove(allocationSegmentId);
        this.allocationStartDeliveryTimeMap.remove(allocationSegmentId);
        this.allocationEndDeliveryTimeMap.remove(allocationSegmentId);
        this.hard1Score = this.hard1Score - newOtherPenaltyValue - newCurrentPenaltyValue + oldOtherPenaltyValue + oldCurrentPenaltyValue;
    }

    private void retractPredecessorDate(Allocation allocation) {
        Long allocationSegmentId = allocation.getSegment().getId();
        String allocationSegmentIdString = allocationSegmentId.toString();
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            String subkey;
            String compositeKey;
            Long segmentOverlap;
            if (Objects.equals(segmentEntry.getValue().getBatch().getId(), allocation.getBatch().getId()) || !segmentEntry.getValue().getName().equals(allocation.getSegment().getName()) || (segmentOverlap = this.segmentOverlapMap.get(compositeKey = BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(allocationSegmentIdString, subkey = segmentEntry.getKey().toString()))) == null) continue;
            this.hard2Score += 2L * segmentOverlap;
            this.segmentOverlapMap.remove(compositeKey);
            this.segmentOverlapMap.remove(BatchSchedulingIncrementalScoreCalculator.generateCompositeKey(subkey, allocationSegmentIdString));
        }
        this.allocationDelayMap.remove(allocationSegmentId);
        this.allocationStartInjectionTimeMap.remove(allocationSegmentId);
        this.allocationEndInjectionTimeMap.remove(allocationSegmentId);
        this.allocationStartDeliveryTimeMap.remove(allocationSegmentId);
        this.allocationEndDeliveryTimeMap.remove(allocationSegmentId);
    }

    public void updateBatchEndDate(AllocationPath allocationPath) {
        long maxEndTime = 0L;
        Long pathBatchId = allocationPath.getBatch().getId();
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            Long batchId;
            String batchRoute;
            Long allocationEndDeliveryTime = this.allocationEndDeliveryTimeMap.get(segmentEntry.getKey());
            if (allocationEndDeliveryTime == null || (batchRoute = this.batchRoutePathMap.get(batchId = segmentEntry.getValue().getBatch().getId())) == null || !batchId.equals(pathBatchId) || !segmentEntry.getValue().getRoutePath().getPath().equals(batchRoute) || allocationEndDeliveryTime <= maxEndTime) continue;
            maxEndTime = allocationEndDeliveryTime;
        }
        this.batchEndTimeMap.put(pathBatchId, maxEndTime);
    }

    public void updateBatchEndDate(Allocation allocation) {
        long maxEndTime = 0L;
        Long allocationBatchId = allocation.getBatch().getId();
        for (Map.Entry<Long, Segment> segmentEntry : this.segmentMap.entrySet()) {
            Long batchId;
            String batchRoute;
            Long allocationEndDeliveryTime = this.allocationEndDeliveryTimeMap.get(segmentEntry.getKey());
            if (allocationEndDeliveryTime == null || (batchRoute = this.batchRoutePathMap.get(batchId = segmentEntry.getValue().getBatch().getId())) == null || !batchId.equals(allocationBatchId) || !segmentEntry.getValue().getRoutePath().getPath().equals(batchRoute) || allocationEndDeliveryTime <= maxEndTime) continue;
            maxEndTime = allocationEndDeliveryTime;
        }
        this.batchEndTimeMap.put(allocationBatchId, maxEndTime);
    }

    public long getMaxEndTime() {
        long maxEndTime = 0L;
        for (Long endTime : this.batchEndTimeMap.values()) {
            if (endTime == null || endTime <= maxEndTime) continue;
            maxEndTime = endTime;
        }
        return maxEndTime;
    }

    private long computeRoutePathSegmentOverlap() {
        HashSet<String> segmentSet = new HashSet<String>();
        for (String segments : this.batchRoutePathMap.values()) {
            if (segments == null) continue;
            segmentSet.addAll(Arrays.asList(RoutePath.getSegmentArray(segments)));
        }
        return this.segmentStringMap.size() - segmentSet.size();
    }

    public BendableLongScore calculateScore() {
        return BendableLongScore.of((long[])new long[]{this.hard0Score, this.hard1Score, this.hard2Score}, (long[])new long[]{this.soft0Score, this.soft1Score});
    }
}

