/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.score;

import java.util.function.Function;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.api.score.buildin.hardsoft.HardSoftScore;
import org.optaplanner.core.api.score.stream.Constraint;
import org.optaplanner.core.api.score.stream.ConstraintCollectors;
import org.optaplanner.core.api.score.stream.ConstraintFactory;
import org.optaplanner.core.api.score.stream.ConstraintProvider;
import org.optaplanner.core.api.score.stream.Joiners;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class CloudBalancingConstraintProvider
implements ConstraintProvider {
    public Constraint[] defineConstraints(ConstraintFactory constraintFactory) {
        return new Constraint[]{this.requiredCpuPowerTotal(constraintFactory), this.requiredMemoryTotal(constraintFactory), this.requiredNetworkBandwidthTotal(constraintFactory), this.computerCost(constraintFactory)};
    }

    Constraint requiredCpuPowerTotal(ConstraintFactory constraintFactory) {
        return constraintFactory.from(CloudProcess.class).groupBy(CloudProcess::getComputer, ConstraintCollectors.sum(CloudProcess::getRequiredCpuPower)).filter((computer, requiredCpuPower) -> requiredCpuPower > computer.getCpuPower()).penalize("requiredCpuPowerTotal", (Score)HardSoftScore.ONE_HARD, (computer, requiredCpuPower) -> requiredCpuPower - computer.getCpuPower());
    }

    Constraint requiredMemoryTotal(ConstraintFactory constraintFactory) {
        return constraintFactory.from(CloudProcess.class).groupBy(CloudProcess::getComputer, ConstraintCollectors.sum(CloudProcess::getRequiredMemory)).filter((computer, requiredMemory) -> requiredMemory > computer.getMemory()).penalize("requiredMemoryTotal", (Score)HardSoftScore.ONE_HARD, (computer, requiredMemory) -> requiredMemory - computer.getMemory());
    }

    Constraint requiredNetworkBandwidthTotal(ConstraintFactory constraintFactory) {
        return constraintFactory.from(CloudProcess.class).groupBy(CloudProcess::getComputer, ConstraintCollectors.sum(CloudProcess::getRequiredNetworkBandwidth)).filter((computer, requiredNetworkBandwidth) -> requiredNetworkBandwidth > computer.getNetworkBandwidth()).penalize("requiredNetworkBandwidthTotal", (Score)HardSoftScore.ONE_HARD, (computer, requiredNetworkBandwidth) -> requiredNetworkBandwidth - computer.getNetworkBandwidth());
    }

    Constraint computerCost(ConstraintFactory constraintFactory) {
        return constraintFactory.from(CloudComputer.class).ifExists(CloudProcess.class, Joiners.equal(Function.identity(), CloudProcess::getComputer)).penalize("computerCost", (Score)HardSoftScore.ONE_SOFT, CloudComputer::getCost);
    }
}

