/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.examples.cloudbalancing.swingui.realtime;

import java.util.ArrayList;
import org.optaplanner.core.api.score.director.ScoreDirector;
import org.optaplanner.core.api.solver.ProblemFactChange;
import org.optaplanner.examples.cloudbalancing.domain.CloudBalance;
import org.optaplanner.examples.cloudbalancing.domain.CloudComputer;
import org.optaplanner.examples.cloudbalancing.domain.CloudProcess;

public class DeleteComputerProblemFactChange
implements ProblemFactChange<CloudBalance> {
    private final CloudComputer computer;

    public DeleteComputerProblemFactChange(CloudComputer computer) {
        this.computer = computer;
    }

    public void doChange(ScoreDirector<CloudBalance> scoreDirector) {
        CloudBalance cloudBalance = (CloudBalance)scoreDirector.getWorkingSolution();
        CloudComputer workingComputer = (CloudComputer)scoreDirector.lookUpWorkingObject((Object)this.computer);
        if (workingComputer == null) {
            return;
        }
        for (CloudProcess process : cloudBalance.getProcessList()) {
            if (process.getComputer() != workingComputer) continue;
            scoreDirector.beforeVariableChanged((Object)process, "computer");
            process.setComputer(null);
            scoreDirector.afterVariableChanged((Object)process, "computer");
        }
        ArrayList<CloudComputer> computerList = new ArrayList<CloudComputer>(cloudBalance.getComputerList());
        cloudBalance.setComputerList(computerList);
        scoreDirector.beforeProblemFactRemoved((Object)workingComputer);
        computerList.remove(workingComputer);
        scoreDirector.afterProblemFactRemoved((Object)workingComputer);
        scoreDirector.triggerVariableListeners();
    }
}

