/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.benchmark.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.optaplanner.benchmark.config.ProblemBenchmarksConfig;
import org.optaplanner.benchmark.config.SolverBenchmarkConfig;
import org.optaplanner.benchmark.config.statistic.ProblemStatisticType;
import org.optaplanner.benchmark.config.statistic.SingleStatisticType;
import org.optaplanner.benchmark.impl.DefaultPlannerBenchmarkFactory;
import org.optaplanner.benchmark.impl.ProblemBenchmarksFactory;
import org.optaplanner.benchmark.impl.result.PlannerBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SingleBenchmarkResult;
import org.optaplanner.benchmark.impl.result.SolverBenchmarkResult;
import org.optaplanner.core.config.solver.EnvironmentMode;
import org.optaplanner.core.config.solver.SolverConfig;
import org.optaplanner.core.config.solver.monitoring.MonitoringConfig;
import org.optaplanner.core.config.solver.monitoring.SolverMetric;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.domain.solution.descriptor.SolutionDescriptor;
import org.optaplanner.core.impl.solver.DefaultSolverFactory;

public class SolverBenchmarkFactory {
    private final SolverBenchmarkConfig config;

    public SolverBenchmarkFactory(SolverBenchmarkConfig config) {
        this.config = config;
    }

    public <Solution_> void buildSolverBenchmark(ClassLoader classLoader, PlannerBenchmarkResult plannerBenchmark, Solution_[] extraProblems) {
        this.validate();
        SolverBenchmarkResult solverBenchmarkResult = new SolverBenchmarkResult(plannerBenchmark);
        solverBenchmarkResult.setName(this.config.getName());
        solverBenchmarkResult.setSubSingleCount((Integer)ConfigUtils.inheritOverwritableProperty((Object)this.config.getSubSingleCount(), (Object)1));
        if (this.config.getSolverConfig().getClassLoader() == null) {
            this.config.getSolverConfig().setClassLoader(classLoader);
        }
        if (this.config.getSolverConfig().getMonitoringConfig() != null && this.config.getSolverConfig().getMonitoringConfig().getSolverMetricList() != null && !this.config.getSolverConfig().getMonitoringConfig().getSolverMetricList().isEmpty()) {
            throw new IllegalArgumentException("The solverBenchmarkConfig (" + this.config + ") has a " + SolverConfig.class.getSimpleName() + " (" + this.config.getSolverConfig() + " ) with a non-empty " + MonitoringConfig.class.getSimpleName() + " (" + this.config.getSolverConfig().getMonitoringConfig() + ").");
        }
        List<SolverMetric> solverMetricList = this.getSolverMetrics(this.config.getProblemBenchmarksConfig());
        solverBenchmarkResult.setSolverConfig(this.config.getSolverConfig().copyConfig().withMonitoringConfig(new MonitoringConfig().withSolverMetricList(solverMetricList)));
        DefaultSolverFactory defaultSolverFactory = new DefaultSolverFactory(this.config.getSolverConfig());
        SolutionDescriptor solutionDescriptor = defaultSolverFactory.buildSolutionDescriptor(EnvironmentMode.REPRODUCIBLE);
        for (Solution_ extraProblem : extraProblems) {
            if (solutionDescriptor.getSolutionClass().isInstance(extraProblem)) continue;
            throw new IllegalArgumentException("The solverBenchmark name (" + this.config.getName() + ") for solution class (" + solutionDescriptor.getSolutionClass() + ") cannot solve a problem (" + extraProblem + ") of class (" + (extraProblem == null ? null : extraProblem.getClass()) + ").");
        }
        solverBenchmarkResult.setScoreDefinition(solutionDescriptor.getScoreDefinition());
        solverBenchmarkResult.setSingleBenchmarkResultList(new ArrayList<SingleBenchmarkResult>());
        ProblemBenchmarksConfig problemBenchmarksConfig_ = this.config.getProblemBenchmarksConfig() == null ? new ProblemBenchmarksConfig() : this.config.getProblemBenchmarksConfig();
        plannerBenchmark.getSolverBenchmarkResultList().add(solverBenchmarkResult);
        ProblemBenchmarksFactory problemBenchmarksFactory = new ProblemBenchmarksFactory(problemBenchmarksConfig_);
        problemBenchmarksFactory.buildProblemBenchmarkList(solverBenchmarkResult, extraProblems);
    }

    protected void validate() {
        if (!DefaultPlannerBenchmarkFactory.VALID_NAME_PATTERN.matcher(this.config.getName()).matches()) {
            throw new IllegalStateException("The solverBenchmark name (" + this.config.getName() + ") is invalid because it does not follow the nameRegex (" + DefaultPlannerBenchmarkFactory.VALID_NAME_PATTERN.pattern() + ") which might cause an illegal filename.");
        }
        if (!this.config.getName().trim().equals(this.config.getName())) {
            throw new IllegalStateException("The solverBenchmark name (" + this.config.getName() + ") is invalid because it starts or ends with whitespace.");
        }
        if (this.config.getSubSingleCount() != null && this.config.getSubSingleCount() < 1) {
            throw new IllegalStateException("The solverBenchmark name (" + this.config.getName() + ") is invalid because the subSingleCount (" + this.config.getSubSingleCount() + ") must be greater than 1.");
        }
    }

    protected List<SolverMetric> getSolverMetrics(ProblemBenchmarksConfig config) {
        ArrayList<SolverMetric> out = new ArrayList<SolverMetric>();
        for (ProblemStatisticType problemStatisticType : Optional.ofNullable(config).map(ProblemBenchmarksConfig::determineProblemStatisticTypeList).orElseGet(ProblemStatisticType::defaultList)) {
            if (problemStatisticType == ProblemStatisticType.SCORE_CALCULATION_SPEED) {
                out.add(SolverMetric.SCORE_CALCULATION_COUNT);
                continue;
            }
            out.add(SolverMetric.valueOf((String)problemStatisticType.name()));
        }
        for (SingleStatisticType singleStatisticType : Optional.ofNullable(config).map(ProblemBenchmarksConfig::determineSingleStatisticTypeList).orElseGet(Collections::emptyList)) {
            out.add(SolverMetric.valueOf((String)singleStatisticType.name()));
        }
        return out;
    }
}

